# Character Classes

## Barbarian

### Class Features

As a barbarian, you have the following class features.

#### Hit Points

**Hit Dice:** 1d12 per barbarian level

**Hit Points at 1st Level:** 12 + your CON modifier

**Hit Points at Higher Levels:** 1d12 (or 7) + your CON modifier per barbarian level after 1st

#### Proficiencies

**Armor:** Light armor, medium armor, shields

**Weapons:** Simple weapons, martial weapons

**Tools:** Herbalism tools

**Saves:** STR, CON

**Skills:** Choose two from Animal Handling, Athletics, Intimidation, Nature, Perception, and Survival

#### Starting Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (_a_) a greataxe or (_b_) any martial melee weapon
- (_a_) two handaxes or (_b_) any simple weapon
- An explorer’s pack and four javelins

#### Barbarian Progression

| LEVEL |  PB |     RAGES | RAGE DAMAGE | FEATURES                                     |
| ----: | --: | --------: | ----------: | -------------------------------------------- |
|   1st |  +2 |         2 |          +2 | Rage, Unarmored Defense                      |
|   2nd |  +2 |         2 |          +2 | Danger Sense, Reckless Attack                |
|   3rd |  +2 |         3 |          +2 | _Barbarian Subclass_                         |
|   4th |  +2 |         3 |          +2 | Improvement                                  |
|   5th |  +3 |         3 |          +2 | Fast Movement, Multiattack (2/Attack Action) |
|   6th |  +3 |         4 |          +2 | Feral Instinct                               |
|   7th |  +3 |         4 |          +2 | _Subclass Feature_                           |
|   8th |  +3 |         4 |          +2 | Improvement                                  |
|   9th |  +4 |         4 |          +3 | Brutal Critical (1 Die)                      |
|  10th |  +4 |         4 |          +3 | Heroic Boon                                  |
|  11th |  +4 |         4 |          +3 | _Subclass Feature_                           |
|  12th |  +4 |         5 |          +3 | Improvement                                  |
|  13th |  +5 |         5 |          +3 | Brutal Critical (2 Dice)                     |
|  14th |  +5 |         5 |          +3 | Relentless Rage                              |
|  15th |  +5 |         5 |          +3 | _Subclass Feature_                           |
|  16th |  +5 |         5 |          +4 | Improvement                                  |
|  17th |  +6 |         6 |          +4 | Brutal Critical (3 Dice)                     |
|  18th |  +6 |         6 |          +4 | Unyielding Might                             |
|  19th |  +6 |         6 |          +4 | Improvement                                  |
|  20th |  +6 | Unlimited |          +5 | Epic Boon                                    |

#### Rage

_1st-Level Barbarian Feature_

In battle, you fight with primal ferocity. On your turn, you can rage as a bonus action.

While raging, you gain the following benefits if you aren’t wearing heavy armor:

- You have advantage on STR ability checks and saves.
- When you make a melee weapon attack using STR, you gain a bonus to the damage roll, which increases as you gain levels as a barbarian (as shown in the Rage Damage column of the Barbarian Progression table). The damage type of this extra damage matches that of the weapon used to deal it.
- You have resistance to bludgeoning, piercing, and slashing damage.

If you can cast spells, you can’t cast them or concentrate on them while raging.

Your rage lasts for 1 minute. It ends early if you are knocked unconscious or if your turn ends and you haven’t attacked a hostile creature or taken damage from a hostile creature since the start of your last turn. You can also end your rage early with a bonus action on your turn.

You can rage a number of times equal to the number listed in the Barbarian Progression table. You regain all expended uses of Rage when you finish a long rest.

#### Unarmored Defense

_1st-Level Barbarian Feature_

While you aren't wearing any armor, your AC equals 13 + your CON modifier. (DEX doesn't factor into your AC for this class feature.) You can use a shield and still gain this benefit.

#### Danger Sense

_2nd-Level Barbarian Feature_

You gain an uncanny sense of impending danger, giving you an edge when avoiding harm. You have advantage on DEX saves while you aren't blinded, deafened, or incapacitated.

#### Reckless Attack

_2nd-Level Barbarian Feature_

You can throw aside concern for defense in favor of ferocious attack. When you make an attack on your turn, you can decide to do it recklessly. Doing so gives you advantage on melee weapon attack rolls using STR during this turn, but attack rolls against you have advantage until the start of your next turn.

#### Barbarian Subclass

_3rd, 7th, 11th, and 15th-Level Barbarian Feature_

Choose a subclass that reflects the path you walk, either Berserker or Wild Fury (detailed at the end of this class). Your choice grants you features at 3rd, 7th, 11th, and 15th level.

#### Improvement

_4th, 8th, 12th, 16th, and 19th-Level Barbarian Feature_

Choose one of the following improvements (ability scores can’t be raised above 20 with this feature):

- Increase a single ability score by 2.
- Increase two different ability scores by 1 each.
- Increase one ability score by 1 and select a talent from the martial talents list.

#### Fast Movement

_5th-Level Barbarian Feature_

Your walking speed increases by 10 feet while you aren't wearing heavy armor. In addition, when you roll initiative, you can immediately move up to half your speed.

#### Multiattack

_5th-Level Barbarian Feature_

Your physical prowess has grown. On your turn, you can make two attacks when you take the Attack action.

#### Feral Instinct

_6th-Level Barbarian Feature_

Your honed instincts give you advantage on initiative rolls. In addition, if you are surprised at the beginning of combat and aren’t incapacitated, you can act normally on your first turn, if you enter a rage before doing anything else on that turn.

#### Brutal Critical

_9th, 13th, and 17th-Level Barbarian Feature_

You score a critical hit on a d20 roll of 19 or 20 with melee weapons and unarmed strikes. You also roll one additional weapon damage die when determining the extra damage for a critical hit with a melee attack.

This extra damage increases to two additional dice at 13th level and three additional dice at 17th level.

#### Heroic Boon

_10th-Level Barbarian Feature_

Your commitment to the barbarian’s path grants you a powerful ability. Choose one of the following heroic boons:

- **Instant Rage.** You can rage (no bonus action required) when you roll initiative and use your Fast Movement feature, if you have at least one use of Rage left to expend.
- **Stubborn Rage.** Your rage ends only when its duration expires, you fall unconscious, or you choose to end it.

#### Relentless Rage

_14th-Level Barbarian Feature_

Your rage lets you shrug off even lethal wounds. While raging, if you are reduced to 0 hit points, you can make a DC 10 CON save. On a success, you don't fall unconscious until your current rage ends. You still make death saves and can be killed outright if you take damage from a single source equal to your hit point maximum. Even if you fail three death saves during your rage, you only die if you end your turn with 0 hit points.

Each time you use this feature after the first, the DC increases by 5. When you finish a short or long rest, the DC resets to 10.

#### Unyielding Might

_18th-Level Barbarian Feature_

You have perfected the application of might and mettle. You gain the following benefits:

- When you make an ability check or save using STR or CON, treat any d20 roll of 9 or lower as a 10.
- Your melee weapon attacks deal additional damage, equal to your STR score, to objects and structures.

#### Epic Boon

_20th-Level Barbarian Feature_

Your commitment to the barbarian’s path grants you a powerful new ability. You gain the following epic boon:

- **Primal Champion.** You embody untamed power. Your STR and CON scores each increase by 4. Your maximum for those scores is now 24.

### Berserker Subclass

Through primal rite or natural bloodthirst, some barbarians can work themselves into a rage so ferocious and explosively violent that it risks breaking their bodies. Berserkers may lose themselves in their frenzy, seething with raw brutality, embracing the blood-soaked battlefield, uncaring of their own safety.

#### Berserker Progression

| BARBARIAN LEVEL | FEATURES                 |
| --------------: | ------------------------ |
|             3rd | Frenzy, Ruthless Bearing |
|             7th | Mindless Rage            |
|            11th | Intimidating Presence    |
|            15th | Retaliation              |

#### Frenzy

_3rd-Level Berserker Feature_

You go into a frenzy when you rage. While raging, you can make a single melee weapon attack as a bonus action on each of your turns.

#### Ruthless Bearing

_3rd-Level Berserker Feature_

Your ferocity looms at all times. You gain proficiency in the Intimidation skill. If you are already proficient, double your PB instead for Intimidation checks.

#### Mindless Rage

_7th-Level Berserker Feature_

While raging, you gain the following benefits:

- You ignore any levels of exhaustion you currently suffer for the duration of your rage.
- You can't be charmed or frightened. If you are already charmed or frightened when you enter a rage, the effect is suspended for the duration of the rage.
- If you score a critical hit or reduce a creature to 0 HP, you gain a number of temporary hit points equal to your PB + your CON modifier. These hit points last until expended or until you finish a short or long rest.

#### Intimidating Presence

_11th-Level Berserker Feature_

Your weapon attacks deal an amount of additional damage, equal to your PB (of the same damage type as the weapon), to frightened creatures.

In addition, as a bonus action, you can attempt to frighten a number of creatures, up to your PB, within 30 feet of you that can see or hear you. Each target must make a WIS save (DC 8 + your PB + your CHA modifier + the number temporary hit points you currently have from your Mindless Rage feature). On a failure, a creature is frightened of you until the end of your next turn.

On subsequent turns, you can use your bonus action to extend the duration of this effect on each frightened creature until the end of your next turn. This effect ends if the creature ends its turn more than 60 feet away from you or can no longer see or hear you.

If the creature succeeds on its save, you can’t use this feature on that creature again for 24 hours.

#### Retaliation

_15th-Level Berserker Feature_

When a creature hits or misses you with an attack, you can use your reaction to move up to half your speed toward that creature and make a single melee attack against it. If the creature is Large or larger, you have advantage on the attack roll.

## Bard

### Class Features

As a bard, you have the following class features.

#### Hit Points

**Hit Dice:** 1d8 per bard level

**Hit Points at 1st Level:** 8 + your CON modifier **Hit Points at Higher Levels:** 1d8 (or 5) + your CON modifier per bard level after 1st

#### Proficiencies

**Armor:** Light armor

**Weapons:** Simple weapons, martial weapons with the Finesse property

**Tools:** One type of musical instrument and two other tools your choice

**Saves:** DEX, CHA

**Skills:** Any three skills of your choice

#### Starting Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (_a_) a rapier or (_b_) any simple weapon
- (_a_) a diplomat's pack or (_b_) an entertainer's pack
- (_a_) a musical instrument or (_b_) a different tool you are proficient with
- Leather armor and a dagger

#### Bard Progression / Arcane Spell Slots By Circle

| LEVEL |  PB | FEATURES                                                                             | CANTRIPS KNOWN | RITUALS KNOWN | SPELLS KNOWN | 1ST | 2ND | 3RD | 4TH | 5TH | 6TH | 7TH | 8TH | 9TH |
| ----: | --: | ------------------------------------------------------------------------------------ | -------------: | ------------: | -----------: | --: | --: | --: | --: | --: | --: | --: | --: | --: |
|   1st |  +2 | Bardic Inspiration (d6), Spellcasting                                                |              3 |             1 |            4 |   2 |   - |   - |   - |   - |   - |   - |   - |   - |
|   2nd |  +2 | Bardic Performance: Celebrate Life, Bardic Performance: Cutting Words, Expertise (2) |              3 |             1 |            5 |   3 |   - |   - |   - |   - |   - |   - |   - |   - |
|   3rd |  +2 | _Bard Subclass_                                                                      |              3 |             2 |            6 |   4 |   2 |   - |   - |   - |   - |   - |   - |   - |
|   4th |  +2 | Improvement                                                                          |              4 |             2 |            7 |   4 |   3 |   - |   - |   - |   - |   - |   - |   - |
|   5th |  +3 | Bardic Inspiration (d8), Font of Inspiration                                         |              4 |             3 |            8 |   4 |   3 |   2 |   - |   - |   - |   - |   - |   - |
|   6th |  +3 | Bardic Performance: Clarity of Thought, Expertise (4)                                |              4 |             3 |            9 |   4 |   3 |   3 |   - |   - |   - |   - |   - |   - |
|   7th |  +3 | _Subclass Feature_                                                                   |              4 |             4 |           10 |   4 |   3 |   3 |   1 |   - |   - |   - |   - |   - |
|   8th |  +3 | Improvement                                                                          |              4 |             4 |           11 |   4 |   3 |   3 |   2 |   - |   - |   - |   - |   - |
|   9th |  +4 | Bardic Inspiration (d10), Magical Secrets                                            |              4 |             5 |           13 |   4 |   3 |   3 |   3 |   1 |   - |   - |   - |   - |
|  10th |  +4 | Heroic Boon                                                                          |              5 |             5 |           14 |   4 |   3 |   3 |   3 |   2 |   - |   - |   - |   - |
|  11th |  +4 | _Subclass Feature_                                                                   |              5 |             6 |           15 |   4 |   3 |   3 |   3 |   2 |   1 |   - |   - |   - |
|  12th |  +4 | Improvement                                                                          |              5 |             6 |           15 |   4 |   3 |   3 |   3 |   2 |   1 |   - |   - |   - |
|  13th |  +5 | Magical Secrets                                                                      |              5 |             7 |           17 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   - |   - |
|  14th |  +5 | Bardic Inspiration (d12)                                                             |              5 |             7 |           18 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   - |   - |
|  15th |  +5 | _Subclass Feature_                                                                   |              5 |             8 |           19 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   - |
|  16th |  +5 | Improvement                                                                          |              5 |             8 |           19 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   - |
|  17th |  +6 | Grand Performance                                                                    |              5 |             9 |           20 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   1 |
|  18th |  +6 | Magical Secrets                                                                      |              5 |             9 |           22 |   4 |   3 |   3 |   3 |   3 |   1 |   1 |   1 |   1 |
|  19th |  +6 | Improvement                                                                          |              5 |             9 |           22 |   4 |   3 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |
|  20th |  +6 | Epic Boon                                                                            |              5 |             9 |           22 |   4 |   3 |   3 |   3 |   3 |   2 |   2 |   1 |   1 |

#### Spellcasting

_1st-Level Bard Feature_

As a conduit for arcane power, you can cast Arcane spells.

##### Cantrips

At 1st level, choose three cantrips from the Arcane spell list to learn. You choose more Arcane cantrips to learn at higher levels, as shown in the Cantrips Known column of the Bard Progression table.

##### Casting Spells

You know several spells and can cast any of them by using an Arcane spell slot of the spell's circle or higher. You don't need to prepare spells ahead of time.

The Bard Progression table shows how many spells you know and how many Arcane spell slots you have at a given level. For example, at 3rd level, you have four 1st-circle slots and two 2nd-circle slots. If you know the 1st-circle spell magic missile and have a 1st-circle and a 2nd-circle spell slot available, you can cast magic missile using either slot. If you use a 1st-circle slot, you have three 1st-circle slots remaining.

You regain all used spell slots when you finish a long rest.

##### Spells Known Of 1st Circle And Higher

At 1st level, choose four 1st-circle spells that you know. Three of these spells must be from the Arcane spell list, but the fourth can be from any source spell list. Regardless of its source, it is an Arcane spell for you.

The Spells Known column of the Bard Progression table shows when you learn additional Arcane spells. Each spell you choose must be from a circle for which you have Arcane spell slots. For instance, when you reach 3rd level as a bard, you can learn one new Arcane spell of 1st or 2nd circle. The Magical Secrets feature also lets you learn spells from other sources at certain levels.

In addition, when you gain a level of bard, you can choose one Arcane spell you know and replace it with another spell of your choice from the Arcane spell list. The replacement spell must be of a circle for which you have Arcane spell slots.

##### Spellcasting Ability

Charisma (CHA) is your spellcasting ability. Your CHA modifier determines the save DC or the attack modifier for certain spells you cast:

- **Spell save DC** = 8 + your proficiency bonus (PB) + your CHA modifier
- **Spell attack modifier** = your proficiency bonus (PB) + your CHA modifier

##### Rituals

You can also cast a type of long-form spell called a ritual. Rituals don't count against your known spell total, and they don't use up spell slots.

At 1st level, choose one ritual from any spell list-Arcane, Divine, Primordial, or Wyrd. Regardless of its source, it becomes an Arcane spell for you. You choose more rituals to learn at higher levels, as shown in the Rituals Known column of the Bard Progression table, but only from a circle for which you have spell slots. Rituals you learn don't count against the number of spells you learn at each level.

##### Spellcasting Focus

You can use a musical instrument or an arcane focus as a spellcasting focus for your Arcane spells. At your GM's discretion, you can use a suitable tool or object from a different tool kit you are proficient with as a spellcasting focus instead.

#### Bardic Inspiration

_1st, 5th, 9th, and 14th-Level Bard Feature_

You can inspire others through stirring words, music, or other kinds of performance. As a bonus action on your turn, you can choose a creature within 60 feet of you, other than yourself, who can hear or see you. That creature gains one Bardic Inspiration die, a d6.

Once within the next 10 minutes, the creature can roll that die and add the number rolled to one ability check, attack roll, or save that it makes. Once the Bardic Inspiration die is rolled, it is lost. A creature can have only one Bardic Inspiration die at a time.

You can use this feature a number of times equal to your CHA modifier. You regain any expended uses when you finish a long rest.

Your Bardic Inspiration die changes when you reach certain levels in this class. The die becomes a d8 at 5th level, d10 at 9th level, and d12 at 14th level.

#### Expertise

_2nd and 6th-Level Bard Feature_

Choose two of your skill proficiencies, or one skill proficiency and one tool proficiency. Double your PB for any ability check you make that uses either of the chosen proficiencies.

At 6th level, you can choose two more of your

proficiencies (any combination of skills or tools) to gain this benefit.

#### Bardic Performance

_2nd and 6th-Level Bard Feature_

You weave magic into ongoing performances to produce effects beyond spells. You start with two effects: Celebrate Life and Cutting Words. You gain a new effect at 6th level, and some bard subclasses grant additional effects. Unless stated otherwise, targets must be within 30 feet of you and be able to hear or see you (depending on the type of performance) to be affected.

As an action, you can use your Bardic Performance feature, choosing which performance effect you create when you do so. Once active, you can continue the performance for up to 1 minute, as long as you spend a bonus action at the start of each of your subsequent turns to maintain it. You can also choose to use your Bardic Inspiration feature as part of the same bonus action required to maintain this performance.

Your performance ends early if you become incapacitated, silenced, use an action to begin a new performance, or choose to end the effect (no action required by you to do so).

You can use your Bardic Performance feature to start a new performance a number of times equal to your PB, regaining all expended uses when you finish a long rest.

##### Bardic Performance: Celebrate Life

At 2nd level, while your Bardic Performance feature is active, allies within range can choose to expend one of their hit dice at the start of their turn. When they do so, they roll the expended die and recover a number of hit points equal to the result + your CHA modifier.

In addition, allies within range have advantage on death saves, though they don't need to see or hear you to receive this benefit.

##### Bardic Performance: Cutting Words

At 2nd level you gain a special reaction while your Bardic Performance feature is active. When a creature within range that you can see makes an ability check, attack roll, or damage roll, you can use your reaction to expend a use of your Bardic Inspiration feature, rolling the die and subtracting the number rolled from the creature's roll. Bardic Performance: Clarity of Thought

Starting at 6th level, you gain this Bardic Performance option. While using your Bardic Performance feature, allies within 30 feet of you can't be charmed and have advantage on saves against being frightened. If an ally within range is already charmed or frightened when you begin your performance, it has advantage on any saves it makes to end the effect as long as your performance continues.

#### Bard Subclass

_3rd, 7th, 11th, and 15th-Level Bard Feature_

Choose a subclass that reflects the college you align with, either Lore or Victory (detailed at the end of this class). Your choice grants you features at 3rd, 7th, 11th, and 15th level.

#### Improvement

_4th, 8th, 12th, 16th, and 19th-Level Bard Feature_

Choose one of the following improvements (ability scores can't be raised above 20 with this feature):

- Increase a single ability score by 2.
- Increase two different ability scores by 1 each.
- Increase one ability score by 1 and select a talent from the technical talents list.

#### Font Of Inspiration

_5th-Level Bard Feature_

You now regain all expended uses of your Bardic Inspiration feature when you finish a short or long rest.

In addition, you can now use your Bardic Inspiration dice in a new way. When a creature within 60 feet of you that you can hear or see you fails an ability check, attack roll, or save, you can use your reaction to expend a use of your Bardic Inspiration feature. When you do, roll the Bardic Inspiration die and add the number rolled to the target's check total-potentially turning a failure into a success.

#### Magical Secrets

_9th, 13th, and 18th-Level Bard Feature_

You've picked up magical knowledge from just about everywhere. Choose two spells (or cantrips) from any spell list. A spell you choose must be of a circle you can cast with your spell slots, as shown on the Bard Progression table.

The chosen spells count as Arcane spells for you and are already included in the number in the Spells Known column at these levels on the Bard Progression table.

You learn two additional spells from any source at 13th level and again at 18th level.

#### Heroic Boon

_10th-Level Bard Feature_

Your commitment to the bard's path grants you a powerful new ability. Choose one of the following heroic boons:

- **Persistent Inspiration.** When a creature adds one of your Bardic Inspiration dice to an ability check, attack roll, or save, and the roll still fails, the die isn't lost and can be used again.
- **Valiant Inspiration.** When a creature with one of your Bardic Inspiration dice successfully deals damage with an attack, the creature can expend and roll the die to deal additional damage equal to the result. The extra damage is of the same type as that of the triggering attack (though the attacker chooses which type if there are more than one). Alternatively, when a creature with one of your Bardic Inspiration dice takes damage, the creature can use its reaction to expend and roll the die to reduce the amount of damage taken #by an amount equal to the result + your CHA modifier.

#### Grand Performance

_17th-Level Bard Feature_

Your Bardic Performance feature now affects creatures within 60 feet of you that can hear or see you.

#### Epic Boon

_20th-Level Bard Feature_

Your commitment to the bard's path grants you a powerful new ability. You gain the following epic boon:

- **Curtain Call.** If you start your turn with no uses of your Bardic Inspiration feature remaining, you can use your bonus action to recover a number of uses equal to your CHA modifier (minimum of 1). This bonus action can be taken as part of the bonus action required to maintain your Bardic Performance feature. Once you use this feature, you can't do so again until you finish a long rest.

### Lore Subclass

Bards who align with the college of Lore value knowledge most highly. Many from this college are preoccupied with preserving ancient rituals, folklore, and stories-or recovering such things that were lost. These bards glean wisdom from all manner of cultures and sources, allowing them to utilize their magic and talents in novel ways.

#### Lore Progression

| Bard Level | Features                                                                    |
| ---------: | --------------------------------------------------------------------------- |
|        3rd | Bardic Performance: Ode to Heroes, Expanded Talent List, Jack of All Trades |
|        7th | Swift Ritual                                                                |
|       11th | Magical Rites                                                               |
|       15th | Peerless Skill                                                              |

#### Bardic Performance

_3rd-Level Lore Feature_

You gain the following Bardic Performance option. Bardic Performance: Ode to Heroes

You invoke songs and stories of legend to inspire your allies to new heights of heroism and to intimidate your foes. When you use your Bardic Performance feature, choose STR, DEX, CON, INT, WIS, or CHA. While your performance lasts, allies within range have advantage on ability checks that use that ability and enemies within range have disadvantage on ability checks that use that ability.

#### Expanded Talent List

_3rd-Level Lore Feature_

When you gain a new talent, you can select it from either the magic or the technical talents list.

#### Jack Of All Trades

_3rd-Level Lore Feature_

You make it your business to collect lessons and practical guidance from the stories, songs, and cultures you encounter. You can add half your PB, rounded down, to any ability check you make that doesn't already include your PB.

#### Swift Ritual

_7th-Level Lore Feature_

You can cast an Arcane ritual you know as an action, instead of using the ritual's listed casting time. You must still provide all other components necessary for the casting. Once used, you can't use this feature again until you finish a long rest.

#### Magical Rites

_11th-Level Lore Feature_

You learn two ritual spells of your choice from any source list. Each spell you choose must be of a circle for which you have spell slots, as shown in the Bard Progression table. The chosen rituals count as Arcane spells for you and aren't included in the number in the Rituals Known column of the Bard Progression table.

#### Peerless Skill

_15th-Level Lore Feature_

When you make an ability check and have at least one use of your Bardic Inspiration feature available, you can use it to roll a Bardic Inspiration die and add the number rolled to your ability check. If you succeed on the check, you get to keep the Bardic Inspiration die, but if you fail the check, the die is expended.

## Cleric

### Class Features

As a cleric, you have the following class features.

#### Hit Points

**Hit Dice:** 1d8 per cleric level
**Hit Points at 1st Level:** 8 + your CON modifier
**Hit Points at Higher Levels:** 1d8 (or 5) + your CON modifier per cleric level after 1st

#### Proficiencies

**Armor:** Light armor, medium armor, shields
**Weapons:** Simple weapons
**Tools:** None
**Saves:** WIS, CHA
**Skills:** Choose two from History, Insight, Medicine, Persuasion, and Religion

#### Starting Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (_a_) a mace or (_b_) a warhammer (if proficient)
- (_a_) scale mail, (_b_) leather armor, or (_c_) chain mail (if proficient)
- (_a_) light crossbow and 20 bolts or (_b_) any simple weapon
- (_a_) a priest's pack or (_b_) an explorer's pack
- A shield and a holy symbol

#### Table: Cleric Progression / Divine Spell Slots By Circle

| Level |  Pb | Features                                       | Cantrips Known | Rituals Known | 1st | 2nd | 3rd | 4th | 5th | 6th | 7th | 8th | 9th |
| ----- | --: | ---------------------------------------------- | -------------: | ------------: | --: | --: | --: | --: | --: | --: | --: | --: | --: |
| 1st   |  +2 | Manifestation of Faith, Spellcasting           |              3 |             1 |   2 |   — |   — |   — |   — |   — |   — |   — |   — |
| 2nd   |  +2 | Channel Divinity: Turn the Profane(1/Rest)     |              3 |             1 |   3 |   — |   — |   — |   — |   — |   — |   — |   — |
| 3rd   |  +2 | _Cleric Subclass_                              |              3 |             2 |   4 |   2 |   — |   — |   — |   — |   — |   — |   — |
| 4th   |  +2 | Improvement                                    |              4 |             2 |   4 |   3 |   — |   — |   — |   — |   — |   — |   — |
| 5th   |  +3 | Destroy the Profane (CR 1/2)                   |              4 |             3 |   4 |   3 |   2 |   — |   — |   — |   — |   — |   — |
| 6th   |  +3 | Channel Divinity (2/Rest)                      |              4 |             3 |   4 |   3 |   3 |   — |   — |   — |   — |   — |   — |
| 7th   |  +3 | _Subclass Feature_                             |              4 |             4 |   4 |   3 |   3 |   1 |   — |   — |   — |   — |   — |
| 8th   |  +3 | Destroy the Profane (CR 1), Improvement        |              4 |             4 |   4 |   3 |   3 |   2 |   — |   — |   — |   — |   — |
| 9th   |  +4 | Divine Intervention                            |              4 |             5 |   4 |   3 |   3 |   3 |   1 |   — |   — |   — |   — |
| 10th  |  +4 | Heroic Boon                                    |              5 |             5 |   4 |   3 |   3 |   3 |   2 |   — |   — |   — |   — |
| 11th  |  +4 | Destroy the Profane (CR 2), _Subclass Feature_ |              5 |             6 |   4 |   3 |   3 |   3 |   2 |   1 |   — |   — |   — |
| 12th  |  +4 | Improvement                                    |              5 |             6 |   4 |   3 |   3 |   3 |   2 |   1 |   — |   — |   — |
| 13th  |  +5 | Channel Divinity (3/Rest)                      |              5 |             7 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   — |   — |
| 14th  |  +5 | Destroy the Profane (CR 3)                     |              5 |             7 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   — |   — |
| 15th  |  +5 | _Subclass Feature_                             |              5 |             8 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   — |
| 16th  |  +5 | Improvement                                    |              5 |             8 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   — |
| 17th  |  +6 | Destroy the Profane (CR 4)                     |              5 |             9 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   1 |
| 18th  |  +6 | Channel Divinity (4/Rest)                      |              5 |             9 |   4 |   3 |   3 |   3 |   3 |   1 |   1 |   1 |   1 |
| 19th  |  +6 | Improvement                                    |              5 |             9 |   4 |   3 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |
| 20th  |  +6 | Epic Boon                                      |              5 |             9 |   4 |   3 |   3 |   3 |   3 |   2 |   2 |   1 |   1 |

#### Spellcasting

_1st-Level Cleric Feature_

As a conduit for divine power, you can cast Divine spells.

##### Cantrips

At 1st level, choose three cantrips from the Divine spell list to learn. You choose more Divine cantrips to learn at higher levels, as shown in the Cantrips Known column of the Cleric Progression table.

##### Preparing Spells

You must prepare spells in advance before you can cast them. You can prepare any spell on the Divine spell list from circles for which you have Divine spell slots. (You determine which spell slots you can access by checking your level on the Cleric Progression table). You can choose a number of spells equal to your WIS modifier + your cleric level (minimum of one spell). This is your list of prepared spells from which you can cast. Preparing a new list of spells requires time spent in prayer and meditation: at least 1 minute per spell circle for each spell you change. You can change your list of prepared spells as part of a long rest.

##### Casting Spells

You have prepared a number of spells and can cast any of them by using a Divine spell slot of the spell's circle or higher.

The Cleric Progression table shows how many Divine spell slots you have at a given level. For example, at 3rd level, you have four 1st-circle and two 2nd-circle spell slots, and with a 16 WIS, you can have six prepared spells of 1st or 2nd circle, in any combination. You only have two spell slots for 2nd-circle spells though, so if you prepare only 2nd-circle spells, you won't be able to use your 1st-circle spell slots at all.

Casting a spell doesn't remove it from your list of prepared spells, it just uses up a spell slot. You regain all used spell slots when you finish a long rest.

##### Spellcasting Ability

Wisdom (WIS) is your spellcasting ability. Your WIS modifier determines the save DC and the attack modifier for certain spells you cast:

- **Spell save DC** = 8 + your proficiency bonus (PB) + your WIS modifier
- **Spell attack modifier** = your proficiency bonus (PB) + your WIS modifier

##### Rituals

You can also cast a type of long-form spell called a ritual. Rituals don't need to be prepared, and they don't use up spell slots.

At 1st level, choose one ritual from the Divine ritual list. You learn more rituals at higher levels, as shown in the Rituals Known column of the Cleric Progression table, but only from a circle for which you have spell slots. Rituals you learn don't count against the number of spells you learn at each level.

#### Spellcasting Focus

You can use a holy symbol as a spellcasting focus for your Divine spells.

#### Manifestation Of Faith

_1st-Level Cleric Feature_

Clerics demonstrate their faith in one of two primary ways, wielding it as a holy warrior or calling it as a miracle worker. Choose how you manifest your faith with one of the following.

**_Manifest Might._** You gain proficiency with heavy armor and one type of martial weapon of your choice. In addition, you gain the ability to infuse your weapon strikes with divine energy: once per turn, when you hit a creature with a weapon attack, you can deal additional radiant or necrotic damage (your choice) equal to your PB.

**_Manifest Miracles._** You learn one additional cantrip of your choice from any source of magic. This cantrip counts as a Divine cantrip for you, but it doesn't count against the number of cantrips you know. In addition, you can add your PB to the damage you deal with any Divine cantrip.

#### Channel Divinity

_2nd, 6th, 13th, and 18th-Level Cleric Feature_

You gain the ability to channel divine energy directly from your deity to produce effects beyond spells. You start with one effect: Turn the Profane. Some subclasses grant additional effects as you advance in levels, as noted in their descriptions.

When you use your Channel Divinity feature, choose which specific effect you want, such as Turn the Profane. Some of these effects require a save, and in those cases, the DC is equal to your cleric spell save DC.

Beginning at 2nd level, you can use your Channel Divinity feature once until you finish a short or long rest, then twice between rests at 6th level, three times at 13th level, and four times at 18th level. When you finish a short or long rest, you regain all expended uses.

##### Channel Divinity: Turn the Profane

As an action, you present your holy symbol and speak a prayer to censure unholy creatures. Each Fiend and Undead of your choice within 30 feet of you and that can see or hear you must make a WIS save. If the creature fails its save, it is turned for 1 minute or until it takes any damage.

A turned creature must try to move as far away from you as it can, though it can't first get closer to you to do it. On its turn, it can use only the Dash action or otherwise try to escape from an effect that prevents it from moving. If there's nowhere to move, it can use the Dodge action. It can't take any reactions.

### Cleric Subclass

_3rd, 7th, 11th, and 15th-Level Cleric Feature_

Choose a subclass that reflects your relationship to your deity, Life, Light, or War (detailed at the end of this class). Your choice grants you spells and other features at 3rd, 7th, 11th, and 15th level.

#### Domain Spells

Each cleric subclass has a list of domain spells that you can access as soon as you can cast spells of that circle (as shown on the Cleric Progression table). Once you gain such a spell, you always have it prepared, and it doesn't count against the number of spells you can prepare. However, casting a domain spell still expends a Divine spell slot as normal.

If one of these spells isn't on the Divine spell list, it still counts as a Divine spell for you.

#### Improvement

_4th, 8th, 12th, 16th, and 19th-Level Cleric Feature_

Choose one of the following improvements (ability scores can't be raised above 20 with this feature):

- Increase a single ability score by 2.
- Increase two different ability scores by 1 each.
- Increase one ability score by 1 and select a talent from the magic talents list.

#### Destroy The Profane

_5th, 8th, 11th, 14th, and 17th-Level Cleric Feature_

When a Fiend or Undead fails its save against your Turn the Profane feature, it is instantly destroyed if its challenge rating (CR) is at or below a certain threshold, as shown in the Destroy the Profane table.

##### Table: Destroy The Profane

| Cleric Level | Destroys Fiends or Undead Of CR ... |
| -----------: | ----------------------------------- |
|          5th | 1/2 or lower                        |
|          8th | 1 or lower                          |
|         11th | 2 or lower                          |
|         14th | 3 or lower                          |
|         17th | 4 or lower                          |

#### Divine Intervention

_9th-Level Cleric Feature_

You can call on your deity to intervene on your behalf when your need is great. At the start of your turn, you can request aid from your deity by rolling a d20 and adding your PB. If the result is 19 or lower, your request fails, and your deity doesn't intervene. If the result is 20 or higher, your deity intervenes on your behalf, imbuing you with a fraction of their power.

If your deity intervenes, you can immediately use your action to cast any spell with a casting time of 1 action from the Divine spell list or your domain spell list, regardless of preparation rules. Casting a spell in this way doesn't expend a spell slot and doesn't require material components. If the spell is of a higher circle than you can normally cast, you must make an ability check using your spellcasting ability to determine whether you cast it successfully. The DC for this check equals 10 + the spell's circle. On a failed check, the spell fails, your deity's power fades, and your action is lost.

Alternatively, on a successful intervention, your GM can propose the form of the intervention. Anything that replicates the effects of a Divine spell is appropriate. In this instance, you still use your action but don't cast a spell. You have final say on allowing the GM to pursue this option or choosing your own spell.

If your deity intervenes, you can't use this feature again for 1 week. Otherwise, you can use it again after you finish a long rest.

#### Heroic Boon

_10th-Level Cleric Feature_

Your commitment to the cleric's path grants you a powerful new ability. Choose one of the following heroic boons:

- **Gift of Consecration.** You are now immune to disease, poison damage, and the poisoned condition. If you die, your body is instantly preserved as per the gentle repose spell for up to a year and a day.
- **Gift of Wrath.** Choose either the radiant or necrotic damage type. You are now resistant to damage of the chosen type. In addition, when you cast a spell that deals damage of any type, you can choose for it to deal radiant or necrotic damage instead (you choose which each casting).

#### Epic Boon

_20th-Level Cleric Feature_

Your commitment to the cleric's path grants you a powerful new ability. You gain the following epic boon:

- **Divine Herald.** When you use your Divine Intervention feature, your deity automatically intervenes without a roll, and you no longer have to wait a week before you use Divine Intervention again, though you can still use it only once per long rest. You are still bound by the other restrictions of the feature.

### Life Domain Subclass

Gods of the Life domain celebrate natural cycles of life and death, exemplifying health and vitality. Devotees of this domain are encouraged to heal the wounded, care for the sick, and oppose the perversion of undeath.

#### Table: Life Domain Progression

| Cleric Level | Features                                                                    |
| -----------: | --------------------------------------------------------------------------- |
|          3rd | _Channel Divinity: Preserve Life_, _Disciple of Life_, _Life Domain Spells_ |
|          7th | _Blessed Healer_                                                            |
|         11th | _Greater Preservation_                                                      |
|         15th | _Perfect Healing_                                                           |

#### Channel Divinity

_3rd-Level Life Feature_

You gain the following Channel Divinity option. Channel Divinity: Preserve Life As an action, you present your holy symbol and evoke healing energy that can restore a number of hit points equal to 5 × your cleric level. Choose any creatures within 30 feet of you and divide those hit points among them. This feature can restore a creature to no more than half of its hit point maximum. This healing has no effect on Undead or Constructs.

#### Disciple Of Life

_3rd-Level Life Feature_

Your healing spells are more effective. When you use a Divine spell of 1st circle or higher to restore hit points to a creature, the creature regains additional hit points equal to 2 + the spell's circle.

#### Life Domain Spells

_3rd-Level Life Feature_

You gain domain spells at the cleric levels listed in the Life Domain Spells table. See the Cleric Subclass class feature for how these spells work.

##### Table: Life Domain Spells

| Cleric Level | Spells                                                 |
| -----------: | ------------------------------------------------------ |
|          3rd | _bless_, _cure wounds_, _gentle repose_, _restoration_ |
|          5th | _mass healing word_, _revivify_                        |
|          7th | _death ward_, _guardian of faith_                      |
|          9th | _greater restoration_, _mass cure wounds_              |

#### Blessed Healer

_7th-Level Life Feature_

Healing spells you cast on others heal you as well. When you cast a Divine spell of 1st circle or higher that restores hit points to a creature other than you, you regain hit points equal to 2 + the spell's circle.

#### Greater Preservation

_11th-Level Life Feature_

The Preserve Life effect of your Channel Divinity feature can now affect any creatures within 60 feet of you. In addition, when you use Preserve Life, one target of your choice can also receive one of the following benefits:

- Cure all diseases affecting the target.
- End one of the following conditions affecting the target: blinded, deafened, paralyzed, or poisoned.
- Neutralize all poisons affecting the target.

#### Perfect Healing

_15th-Level Life Feature_

When you cast a Divine spell of 1st circle or higher that restores hit points, you automatically restore the maximum possible number of hit points. For example, if a cure wounds spell heals 1d8 + 3 hit points, rather than rolling, the target heals 11 hit points.

### War Domain Subclass

Gods of the War domain celebrate strength, the glory of victory, and the thrill of competition. Those gods with evil or chaotic proclivities emphasize destruction and violence, but most societies and heroic characters worship war gods who honor courage and excellence in battle and cherish those who fight when the need is great.

#### Table: War Domain Progression

| Cleric Level | Features                                                                                            |
| -----------: | --------------------------------------------------------------------------------------------------- |
|          3rd | _Channel Divinity: Mark of Triumph_, _Disciple of War_, _Expanded Talent List_, _War Domain Spells_ |
|          7th | _Blessed Warrior_                                                                                   |
|         11th | _Greater Triumph_                                                                                   |
|         15th | _Holy Strike_                                                                                       |

#### Channel Divinity

_3rd-Level War Feature_

You gain the following Channel Divinity option.

##### Channel Divinity: Mark of Triumph

As a bonus action, you present your holy symbol and mystically mark one creature within 60 feet of you that you can see. Until the start of your next turn, all creatures who attack a marked creature have advantage on the first attack roll they make against it.

#### Disciple Of War

_3rd-Level War Feature_

Victory brings you closer to the divine, inspiring you to press beyond your normal limits. Once per turn, when you successfully hit a creature with an attack while using the Attack action, you can choose to make an additional weapon attack as part of that same action.

You can use this feature a number of times equal to your PB. You regain all expended uses when you finish a short or long rest.

#### Expanded Talent List

_3rd-Level War Feature_

When you gain a new talent, you can select that talent from the magic or martial talent list.

#### War Domain Spells

_3rd-Level War Feature_

You gain domain spells at the cleric levels listed in the War Domain Spells table. See the Cleric Subclass class feature for how these spells work.

##### Table: War Domain Spells

| Cleric Level | Spells                                                       |
| -----------: | ------------------------------------------------------------ |
|          3rd | _command_, _magic weapon_, _shield of faith_, _warding bond_ |
|          5th | _fear_, _spirit guardians_                                   |
|          7th | _death ward_, _guardian of faith_                            |
|          9th | _antilife shell_, _flame strike_                             |

#### Blessed Warrior

_7th-Level War Feature_

Attacks you make are particularly potent. When you deal damage with a weapon or spell attack made with a Divine spell, you can reroll any 1s you roll on the damage dice. You must take the new result for any dice rerolled in this way.

#### Greater Triumph

_11th-Level War Feature_

When you use the Mark of Triumph effect of your Channel Divinity feature, you can mystically mark a number of creatures equal to your PB. All targets must be within 60 feet of you.

In addition, when a creature marked by your Mark of Triumph feature is reduced to 0 HP, you can use your reaction to move the mark to a different target within 60 feet of you that you can see. A mark moved in this way still disappears at the start of your next turn, as normal.

#### Holy Strike

_15th-Level War Feature_

Once per turn, when you successfully hit a creature with a weapon or spell attack made with a Divine spell, you can treat the attack as if you rolled a critical hit.

## Druid

### Class Features

As a druid, you have the following class features.

#### Hit Points

**Hit Dice:** 1d8 per druid level
**Hit Points at 1st Level:** 8 + your CON modifier
**Hit Points at Higher Levels:** 1d8 (or 5) + your CON modifier per druid level after 1st

#### Proficiencies

**Armor:** Light armor, medium armor, and shields
**Weapons:** Simple weapons
**Tools:** Herbalist tools
**Saves:** INT, WIS
**Skills:** Choose two from Animal Handling, Arcana, Insight, Medicine, Nature, Perception, Religion, and Survival

#### Starting Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (_a_) a shield or (_b_) any simple weapon
- (_a_) a sickle or (_b_) any simple melee weapon
- Leather armor, an explorer's pack, and a druidic focus

#### Table: Druid Progression / Primordial Spell Slots By Circle

| Level |  PB | Beast Forms Known | Features                                                | Cantrips Known | Rituals Known | 1st | 2nd | 3rd | 4th | 5th | 6th | 7th | 8th | 9th |
| ----- | --: | ----------------: | ------------------------------------------------------- | -------------: | ------------: | --: | --: | --: | --: | --: | --: | --: | --: | --: | --: |
| 1st   |  +2 |                 - | Druidic, Nature's Gift, Spellcasting                    |              3 |             1 |   2 |   - |   - |   - |   - |   - |   - |   - |   - |
| 2nd   |  +2 |                 2 | Wild Shape: Beast Form, Wild Shape: Draw Power (1/Rest) |              3 |             1 |   3 |   - |   - |   - |   - |   - |   - |   - |   - |
| 3rd   |  +2 |                 2 | _Druid Subclass_                                        |              3 |             2 |   4 |   2 |   - |   - |   - |   - |   - |   - |   - |
| 4th   |  +2 |                 2 | Improvement                                             |              4 |             2 |   4 |   3 |   - |   - |   - |   - |   - |   - |   - |
| 5th   |  +3 |                 3 | Improved Beast Form                                     |       (Cr 1/2) |             4 |   3 |   4 |   3 |   2 |   - |   - |   - |   - |   - |   - |
| 6th   |  +3 |                 3 | Wild Shape (2/Rest)                                     |              4 |             3 |   4 |   3 |   3 |   - |   - |   - |   - |   - |   - |
| 7th   |  +3 |                 3 | _Subclass Feature_                                      |              4 |             4 |   4 |   3 |   3 |   1 |   - |   - |   - |   - |   - |
| 8th   |  +3 |                 3 | Improvement                                             |              4 |             4 |   4 |   3 |   3 |   2 |   - |   - |   - |   - |   - |
| 9th   |  +4 |                 4 | Improved Beast Form (CR 1)                              |              4 |             5 |   4 |   3 |   3 |   3 |   1 |   - |   - |   - |   - |
| 10th  |  +4 |                 4 | Heroic Boon                                             |              5 |             5 |   4 |   3 |   3 |   3 |   2 |   - |   - |   - |   - |
| 11th  |  +4 |                 4 | _Subclass Feature_                                      |              5 |             6 |   4 |   3 |   3 |   3 |   2 |   1 |   - |   - |   - |
| 12th  |  +4 |                 4 | Improvement                                             |              5 |             6 |   4 |   3 |   3 |   3 |   2 |   1 |   - |   - |   - |
| 13th  |  +5 |                 5 | Wild Shape (3/Rest)                                     |              5 |             7 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   - |   - |
| 14th  |  +5 |                 5 | Improved Beast Form (CR 2)                              |              5 |             7 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   - |   - |
| 15th  |  +5 |                 5 | _Subclass Feature_                                      |              5 |             8 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   - |
| 16th  |  +5 |                 5 | Improvement                                             |              5 |             8 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   - |
| 17th  |  +6 |                 6 | Nature's Grace                                          |              5 |             9 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   1 |
| 18th  |  +6 |                 6 | Wild Shape (4/Rest)                                     |              5 |             9 |   4 |   3 |   3 |   3 |   3 |   1 |   1 |   1 |   1 |
| 19th  |  +6 |                 6 | Improvement                                             |              5 |             9 |   4 |   3 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |
| 20th  |  +6 |                 6 | Epic Boon                                               |              5 |             9 |   4 |   3 |   3 |   3 |   3 |   2 |   2 |   1 |   1 |

#### Spellcasting

_1st-Level Druid Feature_

As a conduit for primordial power, you can cast Primordial spells.

##### Cantrips

At 1st level, choose three cantrips from the Primordial spell list to learn. You choose more Primordial cantrips to learn at higher levels, as shown in the Cantrips Known column of the Druid Progression table.

##### Preparing Spells

You must prepare spells in advance before you can cast them. You can prepare any spell on the Primordial spell list from circles for which you have Primordial spell slots. (You determine which spell slots you can access by checking your level on the Druid Progression table). You can choose a number of spells equal to your WIS modifier + your druid level (minimum of one spell). This is your list of prepared spells from which you can cast. Preparing a new list of spells requires time spent in prayer and meditation: at least 1 minute per spell circle for each spell you change. You can change your list of prepared spells as part of a long rest.

##### Casting Spells

You have prepared a number of spells and can cast any of them by using a Primordial spell slot of the spell's circle or higher.
The Druid Progression table shows how many Primordial spell slots you have per day at a given level. For example, at 3rd level, you have four 1st-circle and two 2nd-circle spell slots, and with a 16 WIS, you can have six prepared spells of 1st or 2nd circle, in any combination. You only have two spell slots for 2nd-circle spells though, so if you prepare only 2nd-circle spells, you won't be able to use your 1st-circle spell slots at all. Casting a spell doesn't remove it from your list of prepared spells, it just uses up a spell slot. You regain all used spell slots when you finish a long rest.

##### Spellcasting Ability

Wisdom (WIS) is your spellcasting ability. Your WIS modifier determines the save DC or the attack modifier for certain spells you cast:

- **Spell save DC** = 8 + your proficiency bonus (PB) + your WIS modifier
- **Spell attack modifier** = your proficiency bonus (PB) + your WIS modifier

##### Rituals

You can also cast a type of long-form spell called a ritual. Rituals don't need to be prepared, and they don't use up spell slots. At 1st level, choose one ritual from the Primordial ritual list. You learn more rituals at higher levels, as shown in the Rituals Known column of the Druid Progression table, but only from a circle for which you have spell slots. Rituals you learn don't count against the number of spells you learn at each level.

##### Spellcasting Focus

You can use a druidic focus as a spellcasting focus for your Primordial spells.

#### Druidic

_1st-Level Druid Feature_

You know Druidic, the secret language of druids. You can speak the language and use a system of natural elements to leave hidden messages that only other druids will understand. You and others who know this language automatically spot such a message. Others spot the message's presence with a successful WIS (Perception) check but can't decipher it without magic.

#### Nature's Gift

_1st-Level Druid Feature_

You have learned to harness the ambient energy of nature and can redirect that energy to encourage growth and healing. As a bonus action, choose one creature within 5 feet of you (this can be you). When you do so, roll a number of d4s equal to your PB (minimum of 2d4). That creature regains hit points equal to the total rolled. This feature has no effect on Constructs or Undead. You can use this feature a number of times per day equal to your PB. You recover expended uses when you complete a long rest.

#### Wild Shape

_2nd, 6th, 13th, and 18th-Level Druid Feature_

You gain the ability to channel energy directly from nature to produce effects beyond spells. You start with two effects: Beast Form and Draw Power. Some subclasses grant additional effects as you advance in levels, as noted in their descriptions. When you use your Wild Shape feature, simply choose which specific effect you want, such as Beast Form. Some of these effects require a save, and in those cases, the DC is equal to your druid spell save DC. Beginning at 2nd level, you can use your Wild Shape feature once until you finish a short or long rest, then twice between rests at 6th level, three times at 13th level, and four times at 18th level. When you finish a short or long rest, you regain all expended uses.

##### Wild Shape: Beast Form

As an action, you can magically assume the form of a Beast. When you first gain this feature, choose two Beasts of challenge rating (CR) 1/4 or less as your known forms. To select a known form, you must have seen or interacted with a Beast in your past. For example, a druid that hails from a desert environment is unlikely to be familiar enough with a sea-dwelling creature like a dolphin to select it as a known form. The Beast you choose can't have any legendary actions or lair actions. As you advance in druid levels, you can choose more beast forms as shown in the Beast Forms Known column of the Druid Progression table. When you gain a level of druid, you can replace one known form with a different form of your choosing. Any new form you choose must abide by the form restrictions.

###### Rules of Transformation

You can stay in a beast form for a number of hours equal to your PB. You then revert to your normal form unless you expend another use of Wild Shape. You can also choose to revert to your normal form as a bonus action. You automatically revert if you become unconscious, drop to 0 HP while in beast form, or die.

While transformed, your game statistics are replaced by those of your new form, except you retain your INT, WIS, and CHA scores. You also retain your personality. If you make an ability check or save while in beast form, you can choose whether to use either your normal character proficiencies and PB or else use the Beast's listed ability modifier to determine the check total (without your PB in this case).

##### Wild Shape: Draw Power

As a bonus action, you can reshape the natural energies around you to draw them within yourself and recharge your spellcasting ability. When you do so, choose a single expended Primordial spell slot to recover. The recovered spell slot must be of a circle equal to or less than your proficiency bonus (PB). For example, a 5th-level druid with a PB of +3 could recover an expended 1st, 2nd, or 3rd-circle Primordial spell slot with this feature. You can't use Draw Power while transformed by the Beast Form effect of your Wild Shape feature, even if you have multiple uses of Wild Shape available to expend.

#### Druid Subclass

_3rd, 7th, 11th, and 15th-Level Druid Feature_

Choose a subclass that reflects your values and magical practices, either Leaf or Shifter (detailed at the end of this class). Your choice grants you spells and other features at 3rd, 7th, 11th, and 15th level.

##### Ring Spells

Each subclass has a list of ring spells that you can access as soon as you can cast spells of that circle (as shown on the Druid Progression table). Once you gain such a spell, you always have it prepared, and it doesn't count against the number of spells you can prepare. However, casting a ring spell still expends a Primordial spell slot as normal. If one of these spells isn't on the Primordial spell list, it still counts as a Primordial spell for you.

#### Improvement

_4th, 8th, 12th, 16th, and 19th-Level Druid Feature_

Choose one of the following improvements (ability scores can't be raised above 20 with this feature):

- Increase a single ability score by 2.
- Increase two different ability scores by 1 each.
- Increase one ability score by 1 and select a talent from the magic talents list.

#### Improved Beast Form

_5th, 9th, and 14th-Level Druid Feature_

You can now use the Beast Form effect of your Wild Shape feature to assume more powerful beast forms. When you learn a new form, you can choose a Beast of CR 1/2 or less. At 9th level, you can assume the form of any Beast of CR 1 or less. At 14th level, you can assume the form of any Beast of CR 2 or less.

#### Heroic Boon

_10th-Level Druid Feature_

Your commitment to the druid's path grants you a powerful new ability. Choose one of the following heroic boons:

- **Rite of the Kingdom.** All Beasts and creatures with the Animal tag understand your speech, and you can understand their noises and motions as if they were speaking, even if they don't speak a language. This ability doesn't grant Beasts the intelligence to understand or communicate complex concepts, but you can share basic information with ease. Your GM has final say on what a particular creature can express. In addition, you have advantage on Charisma checks made to interact with or influence such creatures.
- **Rite of the Shaper.** When you roll initiative and have no remaining uses of Wild Shape, you regain one use. Once you use this feature, you can't do so again until you complete a long rest.

#### Nature's Grace

_17th-Level Druid Feature_

Your attunement to the natural energies of the world infuses your body, sustaining you and protecting you from unnatural harm. You gain the following benefits:

- You can't be magically aged, and you suffer none of the frailty of old age. You can still die of old age though.
- You no longer need food or water to survive.
- Your ability scores and hit point maximum can't be lowered by any means short of a wish spell.

#### Epic Boon

_20th-Level Druid Feature_

Your commitment to the druid's path grants you a powerful new ability. You gain the following epic boon:

- **Archdruid.** You can use the Beast Form effect of your Wild Shape feature an unlimited number of times. In addition, you can ignore the verbal and somatic components of Primordial spells, as well as any material components that lack a cost.

### Shifter Subclass

Druids that align with the ring of the Shifter feel a deep connection to the animals that walk the world. Shifters delve into the mysteries of transformation, spending much of their time in the forms of the beasts they so admire. To you, there is no greater joy than feeling wind beneath your wings, stalking prey on padded paws, or swimming through crystalline depths.

#### Table: Shifter Progression

| DRUID LEVEL | FEATURES                                       |
| ----------: | ---------------------------------------------- |
|         3rd | Potent Forms, Quick Shift, Shifter Ring Spells |
|         7th | Beast's Fury                                   |
|        11th | Elemental Infusion                             |
|        15th | Manifold Mind                                  |

#### Potent Forms

_3rd-Level Shifter Feature_

You can select more powerful creatures for the known forms used with the Beast Form effect of your Wild Shape feature. When you gain this feature, you can choose any Beast or creature with the Animal tag with a CR of 1 or lower as a known form. In addition, you can now speak any language you know while in beast form-even if your chosen form would not typically allow you to do so. However, you still can't cast spells while transformed, even if a spell requires only a verbal component. At higher druid levels, you can choose beast forms with a CR as high as your druid level divided by 3, rounded down (ignoring CR limitations in your Improved Beast Form feature). For example, upon achieving 6th level of druid, you can choose any Beast of CR 2 or lower as a known form, CR 3 or lower at 9th level, and so on-as shown in the Potent Forms table.

##### Table: Potent Forms

| DRUID LEVEL | MAX CR | EXAMPLE    | DRUID LEVEL | MAX CR | EXAMPLE     |
| ----------: | -----: | ---------- | ----------: | -----: | ----------- |
|         3rd |      1 | Wolf       |        12th |      4 | Elephant    |
|         5th |      1 | Hippogriff |        15th |      5 | Triceratops |
|         6th |      2 | Pegasus    |        18th |      6 | Mammoth     |
|         9th |      3 | Owlbear    |           - |      - | -           |

#### Quick Shift

_3rd-Level Shifter Feature_

By delving into the mysteries of the shifters, you have learned to change form more rapidly. When you use the Beast Form effect of your Wild Shape feature, you can transform as a bonus action instead of as an action.

#### Shifter Ring Spells

_3rd-Level Shifter Feature_

You gain ring spells at the druid levels listed in the Shifter Ring Spells table. See the Druid Subclass class feature for how these spells work.

##### Table: Shifter Ring Spells

| DRUID LEVEL | SPELLS                                                  |
| ----------: | ------------------------------------------------------- |
|         3rd | _alter self_, _animal friendship_, _speak with animals_ |
|         5th | _conjure animals_, _water breathing_                    |
|         7th | _giant insect_, _polymorph_                             |
|         9th | _dominate_, _insect plague_                             |

#### Beast's Fury

_7th-Level Shifter Feature_

Immediately after you take the Attack action on your turn while in beast form, you can use your bonus action to make a single unarmed strike with your claws, hooves, fangs, or whatever natural weapon suits your chosen form. This attack deals 1d6 + your PB damage, and you are considered proficient with it. You decide if this attack deals bludgeoning, piercing, or slashing damage when you first assume your beast form. In addition, all damage you deal with melee weapon attacks while in beast form now counts as magical damage for the purposes of overcoming resistance or immunity to nonmagical damage.

#### Elemental Infusion

_11th-Level Shifter Feature_

By expending two uses of the Beast Form effect of your Wild Shape feature, you can infuse your chosen form with one of the four elemental powers described here. Alternatively, you can use your reaction to spend one use of Wild Shape while already transformed by the Beast Form effect, either infusing yourself with one of the following powers or changing which power is active.

##### Air

You gain a 90-foot flying (hover) speed and are resistant to lightning and thunder damage. You gain the following action:

- **_Whirl (Recharge 4-6)._** Each Large or smaller creature within 5 feet of you must make a STR save (DC 10 + your PB). On a failure, a target takes 3d8 + your PB bludgeoning damage and is flung up to 20 feet away from you in a random direction and knocked prone. If a thrown target strikes a solid surface, it takes 3 (1d6) bludgeoning damage for every 10 feet it was thrown. If the target lands in the same space as another creature, that creature must succeed on a DC 13 DEX save or take the same damage and be knocked prone. The target is then prone in an adjacent unoccupied space. If the target's STR save is successful, a target takes half damage and isn't flung or knocked prone.

##### Earth

You gain a 30-foot burrowing speed and can burrow through nonmagical, unworked earth and stone without disturbing the material you move through. You gain tremorsense to a range of 60 feet and are resistant to bludgeoning, piercing, and slashing damage. Melee attacks you make deal double damage to objects and structures.

##### Fire

You shed bright light in a 30-foot-radius and dim light for an additional 30 feet. You are immune to fire damage. Melee attacks you make deal an additional 1d8 fire damage. When you deal fire damage to a flammable creature or object, you can choose whether it ignites-an ignited target takes 5 (1d10) fire damage at the start of each of its turns until a creature uses an action to douse it. Your GM determines what constitutes a flammable creature or object.

##### Water

You gain a 90-foot swimming speed and can breathe underwater. You are resistant to cold and poison damage. You gain the following action:

- **_Wave (Recharge 4-6)._** Each creature within 5 feet of you must make a STR save (DC 10 + your PB). On a failure, a target takes 2d8 + your PB bludgeoning damage. If a target is Large or smaller, it is also grappled (escape DC 14). Until this grapple ends, the target is restrained and unable to breathe unless it can breathe in water. On a successful STR save, a creature takes half damage and isn't grappled. At the start of each of your turns, each target grappled by you takes 2d8 + your PB bludgeoning damage. A creature within 5 feet of a grappled target can pull it out of the grapple if it expends an action to attempt a DC 14 STR (Athletics) check-freeing the target on a success.

#### Manifold Mind

_15th-Level Shifter Feature_

You can now cast Primordial spells while in beast form, and your form doesn't hinder performing the somatic and verbal components of spells. You must still provide any required material components as normal.

## Fighter

### Class Features

As a fighter, you have the following class features.

#### Hit Points

**Hit Dice:** 1d10 per fighter level
**Hit Points at 1st Level:** 10 + your CON modifier
**Hit Points at Higher Levels:** 1d10 (or 6) + your CON modifier per fighter level after 1st

#### Proficiencies

**Armor:** All armor and shields
**Weapons:** Simple weapons, martial weapons
**Tools:** None
**Saves:** STR, CON
**Skills:** Choose two from Acrobatics, Animal Handling,Athletics, History, Insight, Intimidation, Perception, and Survival

#### Starting Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (_a_) chain mail or (_b_) leather armor, longbow, and 20 arrows
- (_a_) a martial weapon and a shield or (_b_) two martial weapons
- (_a_) a light crossbow and 20 bolts or (_b_) two handaxes
- (_a_) a dungeoneer's pack or (_b_) an explorer's pack

#### Fighter Progression

| LEVEL |  PB | FEATURES                      |
| ----: | --: | ----------------------------- |
|   1st |  +2 | Last Stand, Martial Action    |
|   2nd |  +2 | Action Surge                  |
|   3rd |  +2 | _Fighter Subclass_            |
|   4th |  +2 | Improvement                   |
|   5th |  +3 | Multiattack (2/Attack Action) |
|   6th |  +3 | Improvement                   |
|   7th |  +3 | _Subclass Feature_            |
|   8th |  +3 | Improvement                   |
|   9th |  +4 | Multiattack (3/Attack Action) |
|  10th |  +4 | Heroic Boon                   |
|  11th |  +4 | _Subclass Feature_            |
|  12th |  +4 | Improvement                   |
|  13th |  +5 | Action Surge (2/Rest)         |
|  14th |  +5 | Improvement                   |
|  15th |  +5 | _Subclass Feature_            |
|  16th |  +5 | Improvement                   |
|  17th |  +6 | Multiattack (4/Attack Action) |
|  18th |  +6 | Action Surge (3/Rest)         |
|  19th |  +6 | Improvement                   |
|  20th |  +6 | Epic Boon                     |

#### Last Stand

_1st-Level Fighter Feature_

When you take damage that would reduce your hit points to less than half your hit point maximum (rounded down), you can use your reaction to spend hit dice, up to a number equal to your PB. Immediately roll those hit dice. You regain hit points equal to the sum of all dice rolled + your CON modifier.

#### Martial Action

_1st-Level Fighter Feature_

Your tactical expertise allows you to act quickly on the battlefield. You can take a bonus action on each of your turns in combat to perform a weapon option or one of the martial actions granted by this feature. Choose one of the following martial actions that you know. Aim Requires Wielding a Ranged or Thrown Weapon As a bonus action, you take the time to increase the effectiveness of your next ranged weapon attack. Select one target you can see. If you make a ranged weapon attack against that target before the end of your turn, double your PB for the first attack roll. Guard Requires Wielding a Shield As a bonus action, you raise your shield to intercept incoming attacks. Select one enemy creature within 5 feet of you. That creature has disadvantage on the first attack roll it makes against you or an ally within 5 feet of you before the start of your next turn. Quick Strike Requires Wielding Two Light Weapons After you take the Attack action on your turn and attack with a Light melee weapon that you're holding in one hand, you can use a bonus action to make two attacks with a different Light melee weapon that you're holding in the other hand—instead of the one attack typically granted by two-weapon fighting. Don't add your ability modifier to the damage of these additional attacks unless the modifier is negative. Wind Up Requires Wielding a Heavy or a Versatile Melee Weapon with Both Hands As a bonus action, you ready a powerful attack against a nearby target. Select one target you can see within 10 feet of you. If you hit that target with a melee weapon attack before the end of your turn, the first such attack deals extra damage equal to your PB (of the same damage type as the weapon).

#### Action Surge

_2nd, 13th, and 18th-Level Fighter Feature_

When the need is great, you push your body to its absolute limit. On your turn, you can activate this feature to gain another action—in addition to the action and possible bonus action you regularly get on your turn. Once you use this feature, you must complete a short or long rest before you can use it again. Starting at 13th level, you can use it twice before a rest but only once on the same turn. At 18th level, you can use it three times before a rest but only once on the same turn

#### Fighter Subclass

_3rd, 7th, 11th, and 15th-Level Fighter Feature_

Choose a subclass that reflects your role in battle, either Spell Blade or Weapon Master (detailed at the end of this class). Your choice grants you features at 3rd, 7th, 11th, and 15th level.

#### Improvement

_4th, 6th, 8th, 12th, 14th, 16th, and 19th-Level Fighter Feature_

Choose one of the following improvements (ability scores can't be raised above 20 with this feature):

- Increase a single ability score by 2.
- Increase two different ability scores by 1 each.
  #- Increase one ability score by 1 and select a talent from the martial talents list. ## Multiattack

_5th, 9th, and 17th-Level Fighter Feature_

Your physical prowess has grown. On your turn, you can make two attacks when you take the Attack action. Starting at 9th level, you can make three attacks when you take the Attack action. At 17th level, you can make four.

#### Heroic Boon

_10th-Level Fighter Feature_

Your commitment to the fighter's path grants you a powerful new ability. Choose one of the following heroic boons:

- Defiant. When you fail a save, you can instead choose to succeed on the save. You can use this feature once and regain the use of it when you finish a long rest. You can use it twice before a long rest at 13th level, and three times at 17th.
- Unstoppable. When you start your turn, you can choose to end one of the following conditions affecting you: blinded, charmed, frightened, incapacitated, paralyzed, or stunned. You can use this feature a number of times equal to your PB, and you regain all expended uses when you finish a long rest.

#### Epic Boon

_20th-Level Fighter Feature_

Your commitment to the fighter's path grants you a powerful new ability. You gain the following epic boon:

- Turn the Tide. Once on each of your turns, when you hit a creature or object with a weapon attack on your turn, you can cause the attack to deal additional damage (of the same damage type as the weapon) equal to your STR or DEX score (your choice). The attack's damage ignores #resistance and immunity, and it can't be reduced or avoided by any means.

### Weapon Master Subclass

Most fighters feel a deep connection to their weapons, but none more so than the Weapon Master. For them, a favored bow or blade is a natural extension of their body and a trusted ally. Fighters who pursue this subclass learn to use their chosen arms with efficiency and artistry.

#### Table: Weapon Master Progression

| FIGHTER LEVEL | FEATURES        |
| ------------: | --------------- |
|           3rd | Mastery, Stunts |
|           7th | Deadly Flourish |
|          11th | Advanced Stunts |
|          15th | Grand Final     |

#### Mastery

_3rd-Level Weapon Master Feature_

Choose three types of simple or martial weapons with which you have proficiency. You have mastered the use of those three weapons. Once per turn, when you roll damage for an attack with a weapon you have mastered, you can reroll the weapon's damage dice and use either result. Alternatively, once per turn, when you use a weapon option for a weapon that you have mastered, you can roll the attack's damage even if the weapon option doesn't normally allow it.

#### Stunts

_3rd-Level Weapon Master Feature_

As part of your training, you've learned to use unique tactics with certain weapons. You gain access to special maneuvers called stunts.

To use a stunt, you must wield a weapon that matches the weapon type listed in the stunt description (if one is listed). You can only use one stunt per turn. You gain access to advanced stunts at higher levels.

All stunts listed are available to you at 3rd level. You can perform stunts a number of times equal to your PB + 1. After that, you must finish a short or long rest to regain expended uses.

**Saves.** Some stunts require your target to make a save to resist its effects. The save DC for these stunts is calculated as follows:

- **Stunt save DC** = 8 + your proficiency bonus (PB) + your STR or DEX modifier (your choice)

Stunts are presented in alphabetical order.

##### Arcing Strike

_Requires a Heavy Melee Weapon_

When you deal damage with a heavy weapon wielded in both hands, you can also deal half the damage you dealt to a different target within reach that you can see. If the second target is an object, it takes the full damage instead. You can decide to use this after you know your damage roll.

##### Cheap Shot

_Requires a Melee Weapon_

When you successfully hit a target with a melee weapon as part of the Attack action, you can immediately make an unarmed strike against that target as part of the same Attack action.

##### Make It Count

When you take the Attack action, you can make a single weapon attack with a +10 to the attack roll. On a hit, the attack deals additional damage equal to your fighter level. You can't make additional attacks as part of that Attack action, even if a feature like Multiattack would normally allow you to do so.

##### Parry

_Requires a Melee Weapon_

When a creature you can see hits you with a weapon attack, you can use your reaction to reduce the damage you take by 1d10 + your PB (to a minimum of 0 damage).

##### Redirect

When you miss a target with a weapon attack, you can use your reaction to immediately reroll the attack, but you must select a different target you can see within 5 feet of the original target.

##### Riposte

_Requires a Melee Weapon_

When a creature you can see within range misses you with a weapon attack, you can use your reaction to immediately make a melee weapon attack against that creature.

##### Straight Through

_Requires a Ranged Weapon_

When you deal damage with a ranged weapon attack, you can also deal half the damage you dealt to a different target you can see within 5 feet of the original target. You can decide to use this after you know your damage roll.

##### Tactical Retreat

_Requires a Melee Weapon_

When you hit a creature with a weapon as part of the Attack action, you can immediately move up to half your speed as part of the same action without provoking opportunity attacks.

#### Deadly Flourish

_7th-Level Weapon Master Feature_

Attacks made with weapons you have mastered through your Mastery feature score critical hits on rolls of 19 or 20. When you score a critical hit, you can use your reaction to do one of the following:

- Make a ranged weapon attack against a number of creatures equal to your PB within 15 feet of the target hit by your critical hit.
- Make a separate melee attack against each creature within 5 feet of you.

#### Advanced Stunts

_11th-Level Weapon Master Feature_

The following powerful stunts are available to you whenever you could use a stunt.

##### Assassin's Ambush

When you hit a creature, from which you are hidden, with a weapon attack, roll your weapon damage dice twice instead of once. On a critical hit, roll the weapon's damage dice three times instead of twice.

##### Bulwark

_Requires a Shield_

When you take damage from a spell or ability that requires a save, such as the fireball spell, you can use your reaction to reduce the damage dealt to you by an amount equal to your AC. Psychic damage can't be reduced by this stunt.

##### Felling Sweep

_Requires a Heavy Melee Weapon_

As an action, you can make a single melee attack that targets each creature within reach, using a single attack and damage roll.

##### Preemptive Strike

_Requires a Melee Weapon_

When a creature comes within reach of your weapon, you can use your reaction to make a single attack against it. On a hit, the target's speed is reduced by 15 feet until the start of your next turn.

##### Rapid Release

_Requires a Ranged or Thrown Weapon_

After you take the Attack action, you can use a bonus action to make an additional attack with a ranged or thrown weapon. You can draw a thrown weapon as part of the attack.

##### Wrestler's Clutch

_Requires a Melee Weapon_

When you hit a creature with a melee attack, the creature must succeed on a STR save or become grappled by you. While this grapple persists, stunts you use against the grappled creature don't expend uses of your Stunts feature. This grapple ends if you attack another creature, the target escapes, or you end it (no action required).

#### Grand Finale

_15th-Level Weapon Master Feature_

When you roll initiative and have no uses of your Stunts feature remaining, you can regain 3 uses. You must complete a long rest before you can use this feature again.

## Mechanist

### Class Features

As a mechanist, you have the following class features.

#### Hit Points

**Hit Dice:** 1d10 per mechanist level
**Hit Points at 1st Level:** 10 + your CON modifier
**Hit Points at Higher Levels:** 1d10 (or 6) + your CON modifier per mechanist level after 1st

#### Proficiencies

**Armor:** Light armor, medium armor, and shields
**Weapons:** Simple weapons, martial weapons
**Tools:** Tinker tools and two additional tools your choice
**Saves:** CON, INT
**Skills:** Choose two from Arcana, History, Investigation, Perception, and Sleight of Hand

#### Starting Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (_a_) a martial weapon and a shield or (_b_) two simple weapons
- Light crossbow and 20 bolts
- (_a_) scale mail or (_b_) leather armor
- Tinker tools and a dungeoneer's pack

#### Table: Mechanist Progression

| LEVEL |  PB | AUGMENT EFFECTS KNOWN | AUGMENTED ITEMS | FEATURES                             |
| ----: | --: | --------------------: | --------------: | ------------------------------------ |
|   1st |  +2 |                     - |               - | Eyes of the Maker, Shard of Creation |
|   2nd |  +2 |                     2 |               3 | Augment, Efficient Action            |
|   3rd |  +2 |                     3 |               3 | Mechanist Subclass                   |
|   4th |  +2 |                     3 |               3 | Improvement                          |
|   5th |  +3 |                     4 |               4 | Multiattack (2/Attack Action)        |
|   6th |  +3 |                     4 |               4 | Rapid Augment                        |
|   7th |  +3 |                     5 |               4 | Subclass Feature                     |
|   8th |  +3 |                     5 |               4 | Improvement                          |
|   9th |  +4 |                     6 |               5 | Greater Creation                     |
|  10th |  +4 |                     6 |               5 | Heroic Boon                          |
|  11th |  +4 |                     6 |               5 | Subclass Feature                     |
|  12th |  +4 |                     7 |               5 | Improvement                          |
|  13th |  +5 |                     7 |               6 | Engineer’s Insight                   |
|  14th |  +5 |                     7 |               6 | Ranged Augment                       |
|  15th |  +5 |                     8 |               6 | Subclass Feature                     |
|  16th |  +5 |                     8 |               6 | Improvement                          |
|  17th |  +6 |                     8 |               7 | Always Prepared                      |
|  18th |  +6 |                     9 |               7 | Perfect Creation                     |
|  19th |  +6 |                     9 |               7 | Improvement                          |
|  20th |  +6 |                     9 |               7 | Epic Boon                            |

#### Eyes of the Maker

_1st-Level Mechanist Feature_

When you touch a magic item or some other magic-imbued object, you learn its properties and how to use it, whether it requires attunement to use, and how many charges it has (if any). You learn whether any spells are affecting the item and what they are. If the item was created by a spell, you learn which spell created it.

#### Shard of Creation

_1st-Level Mechanist Feature_

You learn how to craft a shard of creation, which is a Tiny magical object with many uses that appears on your person. In its base state, the shard appears as a constantly shifting, fluid-like bundle of plasma. The shard vanishes instantly if you are slain or if it is not in your possession for more than 24 consecutive hours. If the shard is destroyed or you lose it, you can perform a 1-hour ritual to create a replacement. This ritual can be performed as part of a short or long rest. The shard has a number of charges equal to your INT modifier (minimum of 1), and you regain all expended charges when you finish a long rest. Charges can be spent to activate the following properties.

##### Inspire

When you make an ability check while touching the shard (regardless of its current form), you can spend 1 charge to roll a d6 and add the number rolled to your check result.

##### Transform

While touching the shard, you can use an action to transform it into any type of nonmagical weapon or shield or into any object of Medium size or smaller. The object appears in an unoccupied space within 10 feet of you, but the chosen space must contain a surface or liquid capable of supporting the object. If the object you create is of an appropriate size to be worn or held, you can choose for the object to appear in your hand or on your person. the total value (in gold pieces) of an object created can't be more than 20 × your mechanist level.

A transformed shard remains in its new form until you die, use an action to return it to its original state, or use an action to transform it again. No matter what shape the shard assumes, those who handle the shard can sense something strange about its nature. the shard can't be passed off as a typical item for purposes of buying and selling.

#### Augment

_2nd-Level Mechanist Feature_

You gain the ability to channel magical energy into items. To use this ability, you must spend 1 hour focusing on the item that you wish to augment while remaining in physical contact with it (which can be done as part of a short or long rest).

You gain two augment effects of your choice. Augment effect options are detailed at the end of the class description. At certain mechanist levels, you gain additional augment effects of your choice, as shown in the Augment Effects Known column of the Mechanist Progression table.

When you use this ability, choose an effect from those you know. Regardless of the effect, an augmented item is considered a magic item while the effect remains active. You can apply these effects to existing magic items, and any bonuses or features granted by an augment effect stack with any properties a magic item already possesses.

Unless specified otherwise, a chosen effect lasts indefinitely, but as an action, you can touch an item to end an ongoing effect that you created. You can have effects active on multiple items, provided you spend the required time focusing on each item individually. However, an item can only bear one effect at a time. Multiple uses of the same effect don't stack.

The maximum number of items you can affect with this feature at one time is listed in the Augmented Items column of the Mechanist Progression table. If you try to exceed your maximum, you must choose an ongoing effect to end.

You can also augment your transformed shard of creation, provided its form meets the requirements for the chosen effect. the effect remains with the shard when it transforms as long as the new form remains compatible - if not, the effect immediately ends.

#### Efficient Action

_2nd-Level Mechanist Feature_

Your mechanical expertise allows you to use items more efficiently in the chaos of battle. You can use a bonus action to take the Use an Object action or to perform a weapon option.

#### Mechanist Subclass

_3rd, 7th, 11th, and 15th-Level Mechanist Feature_

Choose a subclass that reflects your relationship to your craft, either Metallurgist or Spellwright (detailed at the end of this class). Your choice grants you features at 3rd, 7th, 11th, and 15th level.

#### Improvement

_4th, 8th, 12th, 16th, and 19th-Level Mechanist Feature_

Choose one of the following improvements (ability scores can't be raised above 20 with this feature):

- Increase a single ability score by 2.
- Increase two different ability scores by 1 each.
- Increase one ability score by 1 and select a talent from either the martial or the technical talents list.

#### Multiattack

_5th-Level Mechanist Feature_

Your physical prowess has grown. On your turn, you can make two attacks when you take the Attack action.

#### Rapid Augment

_6th-Level Mechanist Feature_

You can now use your Augment feature more rapidly. As a bonus action, you can touch an item and imbue it with a known augment effect of your choice. You remain bound by all other restrictions of the Augment feature, including number of items.

You can use your Rapid Augment feature a number of times equal to your INT modifier and regain all expended uses when you finish a long rest.

#### Greater Creation

_9th-Level Mechanist Feature_

Your growing insight into the nature of reality allows you greater control over your Shard of Creation feature. You receive the following enhancements to its given properties.

- **_Inspire_** Your bonus to ability checks is now 1d8 (instead of 1d6).
- **_Transform_** You can now transform the shard into any Large or smaller tool or nonmagical object. All other restrictions still apply, including the limit on the gold piece value.

#### Heroic Boon

_10th-Level Mechanist Feature_

Your commitment to the mechanist's path grants you a powerful new ability. Choose one of the following heroic boons:

- **_Curse of Unmaking._** As an action, you can make a melee spell attack using your augment attack modifier (see Augment Effects) against a creature or item within reach. On a successful hit, the target becomes cursed so that it is vulnerable to all damage. If the target is a creature, it can attempt a CON save against your augment save DC (see Augment Effects) each time it takes a new instance of damage, ending the curse on a success. Once you use this feature, you must finish a long rest before you can use it again.
- **_Mend the Broken._** As an action, you touch a creature or item and cause it to magically regain a number of hit points equal to 5 × your mechanist level. This effect also repairs any catastrophic damage suffered by the target, such as lost limbs, missing parts, or other harm that would ordinarily be irreparable. If the item doesn't have a hit point total, your touch restores it to working order as best it can with the pieces available. This feature can't restore expended charges on magic items or restore magical properties to nonmagical items that were once magical. Once you use this feature, you must finish a long rest before you can use it again.

#### Engineer's Insight

_13th-Level Mechanist Feature_

As long as you have at least 1 minute of uninterrupted focus on a task, when you make an ability check, treat any d20 roll of 9 or lower as though you rolled a 10.

Normal activity like moving doesn't interrupt focus, but attacking, taking damage, or participating in anything that requires initiative order does interrupt focus.

#### Ranged Augment

_14th-Level Mechanist Feature_

You can now use your Rapid Augment feature on items you can see within 60 feet of you. (You no longer need to touch them.)

In addition, if an effect from your Augment feature would typically require you to touch the item to activate its properties, you no longer need to do so as long as the item is within 60 feet of you. You don't need to see the item to activate its properties in this way.

#### Always Prepared

_17th-Level Mechanist Feature_

When you would take damage from an attack, you can use a reaction to take the Use an Object action.

#### Perfect Creation

_18th-Level Mechanist Feature_

Your growing insight into the nature of reality allows you greater control over your Shard of Creation feature. You receive the following enhancements to its given properties.

- **_Inspire_** Your bonus to ability checks is now 1d10 (instead of 1d8).

- **_Transform_** You can now transform the shard into any item - including structures and vehicles - of Huge size or smaller. You are no longer bound by any cost restrictions when choosing a form.

#### Epic Boon

_20th-Level Mechanist Feature_

Your commitment to the mechanist's path grants you a powerful new ability. You gain the following epic boon:

- **Creative Engine.** You gain a +1 bonus to your saves for each effect from your Augment feature currently active on items within 60 feet of you. If you fail a save while any of those items are within 60 feet of you, you can automatically end one of those effects (your choice) to succeed on the save instead.

### Augment Effects

This section lists the effects available for mechanists to learn and use with their Augment feature. Each option lists the type of item required for the effect to function and provides a description of how the effect works. Any effects that require an action to activate their properties can be activated with the Use an Object action. Some effects require you to make an attack roll or require your target to make a save. the attack bonus and save DC for these is calculated as follows:

- **Augment save DC** = 8 + your proficiency bonus (PB) + your Intelligence (INT) modifier
- **Augment attack modifier** = your proficiency bonus(PB) + your Intelligence (INT) modifier

#### Adhesive

_Item Requirement: Large or Smaller Equipment or Object that Isn't Being Worn or Held_

You imbue an item with the ability to stick to surfaces. While the item is within 30 feet of you, you can use an action to speak a command word and affix the item to a solid surface it is touching. the chosen surface can't be part of a creature. While affixed, the item can support up to 1,000 pounds of weight. If additional weight is added, the item detaches from the surface (falling or moving as appropriate).

A creature can spend an action to attempt to remove the affixed item with a STR (Athletics) check. The DC for this check equals 8 + your PB + your INT modifier. If a creature succeeds on this check, the item detaches from the surface.

If the item isn’t forcefully detached, it remains attached for 24 hours or until you use an action to detach it. If the item is detached by any means, its adhesive properties can’t be activated again until you finish a long rest.

#### Collapsible

_Item Requirement: Large or Smaller Item that Isn’t Being Worn, Held, or Fixed in Place_

You imbue an item with the ability to become smaller.

While you touch the item, you can use an action to reduce its size. When you do so, the target is halved in all dimensions, its weight is reduced to 1/8 of normal, and it decreases its size category by one, such as from Medium to Small. The target’s size can’t be reduced further by multiple uses of this feature. As an action, you can touch the target and cause it to return to its original size.

At Higher Levels. Once you reach 9th level in the mechanist class, you can affect Huge or smaller items that meet the other requirements.

#### DETECTING

_Item Requirement: Goggles, Glasses, Spyglass, or Similar_

Equipment or Object with a Transparent Surface You imbue an item with magical capabilities to enhance perception. While you touch the item, you can use an action to activate one of the listed effects. You must equip, wear, or actively look through the augmented item to gain the benefit of the chosen effect:

- **Darkvision.** You gain darkvision out to a range of 30 feet.
- **Invisi-Vision.** You can see invisible creatures and items as if they were visible. You are also aware of any creatures within 30 feet of you or if any creatures come within 30 feet of you, regardless of lighting conditions.
- **Magic Vision.** You gain the benefits of the detect magic spell within 30 feet of you.
- **X-Ray Vision.** You gain the ability to see through solid material within 30 feet of you. To you, solid items within that radius appear transparent and don’t prevent light from passing through them. The vision can penetrate 1 foot of stone, 1 inch of common metal, or up to 3 feet of wood or dirt. Thicker substances block your vision, as does a thin sheet of lead.

While the augmented item is activated, you can use an action to deactivate it or switch the type of vision the item bestows. You can keep the item activated for up to 1 minute, all at once or in several shorter spans, each one using a minimum of 6 seconds (1 round) from the duration. The effect fully recharges when you finish a long rest.

At Higher Levels. Once you reach 9th level in the mechanist class, the range of all vision effects increases to 60 feet.

#### Empowered

_Item Requirement: Weapon_

You imbue a weapon with offensive power. the weapon gains a +1 bonus to attack and damage rolls. If it wasn't already magical, it is now. If it was already magical, this bonus stacks with any existing bonuses. At Higher Levels. Once you reach 9th level in the mechanist class, the attack and damage bonus increases to +2. At 15th level, it becomes +3.

#### Illusive

_Item Requirement: Large or Smaller Item_

You imbue an item with the ability to mask its true appearance. While you touch the target, you can use an action to cause the item to appear as a different item of the same size and general composition. You can't use this feature to change a target's overall nature. For instance, a vehicle must always appear as another kind of vehicle, and equipment must appear as some other kind of equipment. Otherwise, the extent of the illusion is up to you. The change in appearance doesn't hold up to physical inspection. For example, if you use this effect to make a sharpened sword seem dull, anyone who touched the blade would be harmed as if they touched a fine-edged blade. To discern whether an item is disguised, a creature can use its action to inspect the item and must succeed on an INT (Investigation) check against your augment save DC. At Higher Levels. Once you reach 9th level in the mechanist class, you can affect Huge or smaller items.

#### Loading

_Item Requirement: Weapon with the Ammunition Property_

You imbue an item with the ability to conjure magic ammunition. When you wield the weapon, an appropriate piece of ammunition magically appears in place as you attack. Any damage dealt by this ammunition is considered magical. If you use this effect on a weapon with the Loading property, you don't need to spend any time reloading the weapon.

#### Phosphorescent

_Item Requirement: Small or Smaller Item that Can Be Worn or Held_

You imbue an item with the ability to glow. While the item is on your person, you can use an action to cause the item to emit bright light in a 20-foot radius and dim light for an additional 20 feet. When you first activate the item, you can choose whether this light shines normally or whether it can only be seen by a number of creatures of your choice within 30 feet of you. The maximum number of creatures you can include equals your INT modifier. The light can be any color you choose. 

You can cause the item to stop emitting light at any time (no action required). 

At Higher Levels. Once you reach 9th level in the mechanist class, the radius increases to bright light in a 30-foot radius and dim light for an additional 30 feet. You can choose for the bright light to be sunlight.

#### Propulsive

_Item Requirement: Armor (not Shields) or Small or Smaller Object that Can Be Worn_

You imbue an item with the ability to increase the wearer's speed. While wearing the augmented item, your base movement speed is increased by 5 feet. In addition, while you wear the item, you can use an action to move vertically up to 10 feet and remain suspended there for up to 1 minute. You can repeat this action on subsequent turns, rising up to an additional 10 feet each time you do so. While suspended, you can move only by pushing or pulling against a fixed item or surface within reach (such as a wall or ceiling), which allows you to move as if you were climbing. When this effect ends or you choose to end it (no action required), you float gently to the ground if you are still aloft, and you can't activate this Augment effect again until you finish a long rest. At Higher Levels. Once you reach 9th level in the mechanist class, the movement speed bonus increases to 10 feet. At 15th level, it becomes 20 feet.

#### Protean

_Item Requirement: Weapon_

You imbue a weapon with the ability to change its damage type. When you successfully deal damage with the augmented weapon, you can replace the weapon's damage type with another type of your choice. Damage altered in this way is always considered magical for purposes of overcoming resistances and immunities. You can use this augment effect a number of times equal to your PB and regain all expended uses when you finish a long rest.

#### Reactive

_Item Requirement: Large or Smaller Item that Isn't Being Worn, Held, or Fixed in Place_

You imbue an item with the ability to detect specific triggers and react in one of several ways. While you touch the item, you can use an action to set or change the item's trigger and reaction. You can set the item to trigger when a creature you specify comes within 30 feet of it. This can be a specific creature you have met, such as “Jon the messenger,” a general visual description, such as “anyone wearing a city watch uniform,” or a creature type, such as “Celestials.” Your GM has final say on what is reasonable for a trigger. When triggered, you instantly become mentally aware that the item has been triggered, and the item can react in one of the following ways. At your GM's discretion, an item might be able to react in other comparable ways: Recording. the item begins to record everything it can “see” and “hear” within 60 feet of it for the next hour, perceiving as a creature with typical vision or hearing could. After 1 hour, the item ceases to record new information and stores the recording until the item is no longer augmented or until you use an action to set a new trigger or reaction. While a recording is stored, you or any creature of your choosing can touch the item to mentally see and hear anything contained in the recording. Sound. the item emits a sound for up to 1 minute that can be heard to a range of 60 feet (you choose quality and range), such as the sound of ringing bells or a set of bird calls. Alternatively, you can cause it to emit a pre- determined message of 25 words or less in your own voice. At Higher Levels. Once you reach 9th level in the mechanist class, the item can react when a specified creature comes within 60 feet of it.

#### Reinforced

_Item Requirement: Item with Hit Points_

You fortify an item. the target's hit points and hit point maximum increase by an amount equal to 5 × your mechanist level. If the item is destroyed while this effect is active, the effect ends.

#### Returning

_Target: Equipment or Object that Can Fit in the Hand and Isn't Being Worn or Held_

You imbue an item with the ability to return to your hand. While the augmented item is within 60 feet, you can cause it to instantly teleport into your hand (no action required). You must have at least one hand free for this ability to function. At Higher Levels. Once you reach 9th level in the mechanist class, you can affect an item up to 120 feet away from you. At 15th level, you can affect an item anywhere on the same plane as you.

#### Repellant

_Item Requirement: Shield_

You imbue an item with the ability to repel attackers. When a Large or smaller creature hits you with a melee attack, you can use your reaction to force the target to make a STR save against your augment save DC. On a failure, the creature is pushed 15 feet away from you. If the creature encounters a solid surface (like a wall) before moving the full amount, it takes 1d6 bludgeoning for each 10-foot increment it moved.

At Higher Levels. Once you reach 9th level in the mechanist class, a target that fails its save is pushed 30 feet away from you.

### Metallurgist Subclass

Mechanists who pursue the Metallurgist's craft delight in the thrill of combat and engineered armaments. Metallurgist creations are awesome to behold in battle, though few enemies live to spread tales of their terrifying metal mechanisms.

#### Table: Metallurgist Progression

| MECHANIST LEVEL | FEATURES                         |
| --------------: | -------------------------------- |
|             3rd | Augment: Absorbing, Mystic Metal |
|             7th | Heavy Hitter (d6)                |
|             9th | Heavy Hitter (d8), Juggernaut    |
|            15th | Full Metal, Heavy Hitter (d10)   |

#### Augment: Absorbing

_3rd-Level Metallurgist Feature_

You gain the following unique effect for your Augment feature. This effect can't be replaced and doesn't count against the number of effects that you know, as shown in the Augment Effects Known column of the Mechanist Progression table. 

**Absorbing**

_Item Requirement: Armor or Shield_

You empower armor or a shield with the ability to absorb and adapt to different damage types. When you take a single instance of acid, cold, fire, force, lightning, poison, or thunder damage while wearing or wielding the item, you can use your reaction to reduce the damage taken by an amount equal to twice your INT modifier. You then gain resistance to the triggering damage type for 1 minute or until you use this feature to absorb a different damage type. 

You can use this feature a number of times equal to your PB, regaining all expended charges when you finish a long rest.

#### Mystic Metal

_3rd-Level Metallurgist Feature_

You learn to transmute armor into a mystical form. If you spend 1 hour of uninterrupted focus in contact with a nonmagical suit of armor (which can be done as part of a short or long rest), you can transmute that armor into a suit of mystic metal. The transformation lasts until you choose to end it or until you use this feature to transmute a different suit of armor. 

Any ongoing effects from your Augment feature on the armor automatically end when the armor reverts to its normal state. If anyone other than you attempts to don the mystic metal, it instantly reverts to its normal state. 

Once transformed, the mystic metal resembles a head-to-toe suit of metallic armor, but you choose its color, style, and other cosmetic details. Regardless of appearance, mystic metal armor is not made of natural materials such as metal or wood. Therefore, it isn't affected by magic like the heat metal spell or abilities like that of a rust monster. The mystic metal is lightweight and doesn't hinder movement, and you are considered proficient with it. 

Your mystic metal functions as a magic suit of armor with the following properties:

- Each gauntlet of the armor functions as a simple melee weapon with the Light property (which you are proficient with). You can choose whether you use your STR or INT modifier to determine the attack bonus and damage dealt by the gauntlets. On a successful hit, a gauntlet deals 1d6 + your STR or INT modifier (your choice) magical bludgeoning damage.
- If it is on the same plane as you, you can use a bonus action to summon the armor. When you do so, you choose whether the armor appears in an unoccupied space within 5 feet of you or if it appears on you, fully donned. If you are already wearing armor when you summon the mystic metal armor, it can't appear on you.
- While worn, the armor is attached to your body and can't be removed against your will.
- While you wear the armor, your AC equals 13 + your INT modifier.
  
Creatures who handle or inspect the mystic metal can tell it isn't a true magic item. Otherwise, it follows the rules of a typical magic item. the creature encounters a solid surface (like a wall) before moving the full amount, it takes 1d6 bludgeoning for each 10-foot increment it moved. At Higher Levels. Once you reach 9th level in the mechanist class, a target that fails its save is pushed 30 feet away from you.

#### Heavy Hitter

_7th-Level Metallurgist Feature_

You learn to upgrade the offensive capabilities of your Mystic Metal feature. While wearing the armor, you gain the following benefits:

- When you deal damage with a weapon attack, you deal an additional 1d6 force damage. This extra damage increases at higher levels, becoming 1d8 at 9th level and 1d10 at 15th level.
- When you make a weapon attack, you score a critical hit on a roll of 19 or 20.

#### Juggernaut

_11th-Level Metallurgist Feature_

While wearing the armor from your Mystic Metal feature, you have proficiency in the Athletics skill, and you have advantage on any check made to initiate a grapple or shove, or to perform any weapon option that requires a STR check. In addition, if you move at least 15 feet on your turn before making a melee weapon attack, you have advantage on the attack roll.

#### Full Metal

_15th-Level Metallurgist Feature_

While wearing the armor from your Mystic Metal feature, you can use a bonus action to transform it into a nigh-impervious state for 1 minute. If you are reduced to 0 HP, you can choose for the Full Metal feature to automatically activate (no action required). While this state is active, you are immune to bludgeoning, piercing, and slashing damage, and you have resistance to all other damage types. Once this state is used, you can't activate it again until you complete a long rest.

## Monk

### Class Features

As a monk, you have the following class features.

#### Hit Points

Hit Dice: 1d8 per monk level Hit Points at 1st Level: 8 + your CON modifier Hit Points at Higher Levels: 1d8 (or 5) + your CON modifier per monk level after 1st

#### Proficiencies

Armor: None Weapons: Simple weapons, shortswords Tools: One of your choice Saves: STR, DEX Skills: Choose two from Acrobatics, Athletics, History, Insight, Religion, and Stealth

#### Starting Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (a) any simple weapon
- (a) a dungeoneer's pack or (b) an explorer's pack
- (a) 10 darts or (b) a sling

#### Table: Monk Progression

| LEVEL |  PB | MARTIAL ARTS | TECHNIQUE POINTS | UNARMORED MOVEMENT | FEATURES                                       |
| ----- | --: | -----------: | ---------------: | -----------------: | ---------------------------------------------- |
| 1st   |  +2 |          1d4 |                - |                  - | Martial Arts, Unarmored Defense                |
| 2nd   |  +2 |          1d4 |                3 |             +10 ft | Techniques, Unarmored Movement                 |
| 3rd   |  +2 |          1d4 |                5 |             +10 ft | Monk Subclass                                  |
| 4th   |  +2 |          1d4 |                5 |             +10 ft | Improvement                                    |
| 5th   |  +3 |          1d6 |                6 |             +10 ft | Multiattack (2/Attack Action), Stunning Strike |
| 6th   |  +3 |          1d6 |                7 |             +15 ft | Empowered Strikes, Evasion                     |
| 7th   |  +3 |          1d6 |                8 |             +15 ft | Subclass Feature                               |
| 8th   |  +3 |          1d6 |                9 |             +15 ft | Improvement                                    |
| 9th   |  +4 |          1d6 |                9 |             +15 ft | Perfect Motion                                 |
| 10th  |  +4 |          1d6 |               10 |             +20 ft | Heroic Boon                                    |
| 11th  |  +4 |          1d8 |               11 |             +20 ft | Subclass Feature                               |
| 12th  |  +4 |          1d8 |               12 |             +20 ft | Improvement                                    |
| 13th  |  +5 |          1d8 |               13 |             +20 ft | Astral Teachings                               |
| 14th  |  +5 |          1d8 |               14 |             +25 ft | Diamond Soul                                   |
| 15th  |  +5 |          1d8 |               15 |             +25 ft | Subclass Feature                               |
| 16th  |  +5 |          1d8 |               16 |             +25 ft | Improvement                                    |
| 17th  |  +6 |         1d10 |               17 |             +25 ft | Timeless Self                                  |
| 18th  |  +6 |         1d10 |               18 |             +30 ft | Empty Body                                     |
| 19th  |  +6 |         1d10 |               19 |             +30 ft | Improvement                                    |
| 20th  |  +6 |         1d10 |               20 |            +30 ft. | Epic Boon                                      |

#### Martial Arts

_1st-Level Monk Feature_

You have mastery of combat styles that use unarmed strikes and monk weapons, which are shortswords and any simple melee weapons that don't have the Two-handed or Heavy property. You gain the following benefits while you are unarmed or wielding only monk weapons and you aren't wearing armor or wielding a shield:

- You can roll a d4 in place of the normal damage of your unarmed strike or monk weapon. This die changes as you gain monk levels, as shown in the Martial Arts column of the Monk Progression table.
- You can use DEX instead of STR for attack and damage rolls of your unarmed strikes and monk weapons.
- When you are hit by a ranged weapon attack, you can use your reaction to reduce the damage you take from the attack by 1d10 + your DEX modifier + your monk level. If you reduce the damage to 0, you can catch the missile or thrown weapon if it is small enough for you to hold in one hand and you have at least one hand free. If you catch a missile in this way, you can make a ranged attack with the weapon or piece of ammunition you just caught, as part of the same reaction. You make this attack with proficiency, regardless of your weapon proficiencies, and the missile counts as a monk weapon for the attack, with a normal range of 20 feet and a long range of 60 feet.
- When you use the Attack action with an unarmed strike or a monk weapon on your turn, you can make one unarmed strike as a bonus action. For example, if you take the Attack action and attack with a quarterstaff, you can also make an unarmed strike as a bonus action, assuming you haven't already taken a bonus action this turn.

#### Unarmored Defense

_1st-Level Monk Feature_

While you are wearing no armor and not wielding a shield, your AC equals 10 + your DEX modifier + your WIS modifier.

#### Techniques

_2nd-Level Monk Feature_

Your training gives you access to special techniques that allow you to amplify and manipulate the energy within yourself and the environment. Your ability to use this energy is represented by technique points. Your monk level determines the number of points you have, as shown in the Technique Points column of the Monk Progression table.

You can spend these points to fuel various techniques. You start knowing three techniques: Flurry of Blows, Patient Defense, and Step of the Wind. You learn more technique features as you gain levels in this class. You recover expended technique points when you finish a short or long rest. You must spend at least 30 minutes of the rest meditating to regain your technique points.

Some of your techniques require your target to make a save to resist the technique's effects. The save DC is calculated as follows:

**Technique save DC** = 8 + your proficiency bonus (PB) + your WIS modifier

- **Flurry of Blows** Immediately after you use an action on your turn, you can spend 1 technique point to make two unarmed strikes or make one attack with a monk weapon as a bonus action.
- **Patient Defense** You can spend 1 technique point to take the Dodge action as a bonus action on your turn.
- **Step of the Wind** You can spend 1 technique point to take the Disengage or Dash action as a bonus action on your turn. When you do so, your jump distance is doubled until the start of your next turn.

#### Unarmored Movement

_2nd-Level Monk Feature_

Your walking speed increases by 10 feet while you aren't wearing armor or wielding a shield. This bonus increases when you reach certain monk levels, as shown in the Monk Progression table.

#### Monk Subclass

_3rd, 7th, 11th, and 15th-Level Monk Feature_

Choose a subclass that reflects your method for connecting with the energies of the universe, either Flickering Dark or Open Hand (detailed at the end of this class). Your subclass grants you features at 3rd, 7th, 11th, and 15th level.

#### Improvement

_4th, 8th, 12th, 16th, and 19th-Level Monk Feature_

- Choose one of the following improvements (ability scores can't be raised above 20 with this feature):
- Increase a single ability score by 2.
- Increase two different ability scores by 1 each.
- Increase one ability score by 1 and select a talent from the martial talents list.

#### Multiattack

_5th-Level Monk Feature_

Your physical prowess has grown. On your turn, you can make two attacks when you take the Attack action.

#### Stunning Strike

_5th-Level Monk Feature_

You can interfere with the flow of energy in an opponent's body. Once per turn, when you successfully hit another creature with an unarmed strike or monk weapon, you can spend 1 technique point to attempt to stun your foe. When you do so, the target takes damage from your attack as normal and then it must succeed on a CON save or be stunned until the end of your next turn. Each time a stunned target takes damage, it can repeat the save, ending the stunned effect on a success.

#### Empowered Strikes

_6th-Level Monk Feature_

Your unarmed strikes count as magical for the purpose of overcoming resistance and immunity to nonmagical attacks and damage.

#### Evasion

_6th-Level Monk Feature_

You can dodge out of the way of certain area effects, such as a blue dragon's lightning breath or a fireball spell. When you are subjected to an effect that allows you to make a DEX save to take only half damage, you instead take no damage if you succeed on the save and only half damage if you fail.

#### Perfect Motion

_9th-Level Monk Feature_

While you aren't wearing armor or wielding a shield, you gain the following benefits:

- When you fall, you can use your reaction to reduce any falling damage you would take by an amount equal to 5 × your monk level.
- You can move along vertical surfaces and across liquids on your turn without falling during the move. If you end your movement or if your movement is interrupted while you are standing on a vertical surface or on liquid, you fall as normal.

#### Heroic Boon

_10th-Level Monk Feature_

Your commitment to the monk's path grants you a powerful new ability. Choose one of the following heroic boons:

- **Purity of Body.** Your mastery of the energy flowing through your body makes you immune to disease, poison damage, and the poisoned condition. In addition, when you are reduced to 0 HP but not killed outright, you can instantly reset your hit point total to your current number of technique points. You can't recover hit points in this way again until you finish a long rest.
- **Purity of Mind.** The clearness of your mind gives you advantage on Wisdom saves. As a bonus action, you can end one effect on yourself that is causing you to be charmed or frightened.

#### Astral Teachings

_13th-Level Monk Feature_

As an action, you can expend 2 technique points to become proficient in one language, skill, tool, or weapon of your choice until you are incapacitated or use this feature again.

#### Diamond Soul

_14th-Level Monk Feature_

Your mastery of energy grants you proficiency in all saves. In addition, when you make a save and fail, you can spend 1 technique point to reroll it. You must take the second result.

#### Timeless Self

_17th-Level Monk Feature_

Your spirit sustains you, body and mind. You gain the following benefits:

- You can't be magically aged and suffer none of the frailty of old age. You can still die of old age, however.
- You no longer need food or water.
- Your ability scores and hit point maximum can't be lowered or reduced by any means short of a wish spell.

#### Empty Body

_18th-Level Monk Feature_

You can use your action to spend 4 technique points to become invisible for 1 minute. During that time, you also have resistance to all damage but force damage. In addition, you can spend 8 technique points to cast the astral projection spell as an action (ignoring the standard casting time), without needing material components. When you do so, you can't take any other creatures with you.

#### Epic Boon

_20th-Level Monk Feature_

Your commitment to the monk's path grants you a powerful new ability. You gain the following epic boon:

- Boundless Technique. When you roll for initiative, you regain up to 4 expended technique points. If you start your turn with no technique points remaining, you regain 2 technique points.

### Open Hand Subclass

Monks of the Open Hand hone their bodies to physical perfection. They learn techniques to push and trip their opponents, practice advanced meditation to protect them from harm, and develop secret techniques to transform their bodies into the ultimate weapon.

#### Table: Open Hand Progression

| MONK LEVEL | FEATURES                          |
| ---------: | --------------------------------- |
|        3rd | Focus Intent, Open Hand Technique |
|        7th | Wholeness of Body                 |
|       11th | Tranquil Soul                     |
|       15th | Quivering Palm                    |

#### Focus Intent

_3rd-Level Open Hand Feature_

When you or a creature within 5 feet of you makes an ability check or attack roll, you can use your reaction to roll your martial arts die. The target gains a bonus or a penalty (your choice) to its roll equal to the number you rolled. You can use this feature a number of times equal to your WIS modifier. You regain all expended uses when you finish a long rest.

#### Open Hand Technique

_3rd-Level Open Hand Feature_

You can manipulate your enemy's energy with your own. When you hit a creature with one of the attacks granted by your Flurry of Blows technique, you can impose one of the following effects on that target:

- It can't take reactions until the end of your next turn.
- It must succeed on a DEX save or be knocked prone.
- It must succeed on a STR save or be pushed up to 15 feet away from you.

#### Wholeness Of Body

_7th-Level Open Hand Feature_

When you roll initiative and have at least 1 hit point, you regain a number of hit points equal to your CON modifier

- your monk level.

#### Tranquil Soul

_11th-Level Open Hand Feature_

You have learned the way of war, so you may better walk the world in peace. As an action, you can spend 3 technique points to cast the sanctuary spell on yourself. The spell lasts until the end of your next short or long rest (or it can end early as normal).

#### Quivering Palm

_15th-Level Open Hand Feature_

As an action, you can make a single unarmed strike against a creature. On a hit, you can spend 4 technique points to fill that creature with potentially lethal vibrations that last for a number of days equal to your monk level.

For the duration, so long as you and the target are on the same plane, you can use an action to end the vibrations, ripping the creature apart. When you do, the target must make a CON save. On a failure, the target takes force damage equal to 5 × your monk level and is paralyzed until the end of your next turn. On a success, the target is stunned for 1 minute, and at the end of each of their turns, and each time they take damage, the target can repeat the save, ending the effect on a success. A target that fails the save by 5 or more instantly dies.

Each time you use this feature after the first, the technique cost to use it increases by 2. When you finish a long rest, the cost resets. This feature can affect only one target at a time.

## Paladin

### Class Features

As a paladin, you have the following class features.

#### Hit Points

**Hit Dice:** 1d10 per paladin level
**Hit Points at 1st Level:** 10 + your CON modifier
**Hit Points at Higher Levels:** 1d10 (or 6) + your CON modifier per paladin level after 1st

#### Proficiencies

**Armor:** All armor and shields
**Weapons:** Simple weapons, martial weapons
**Tools:** None
**Saves:** WIS, CHA
**Skills:** Choose two from Athletics, Insight, Intimidation, Medicine, Persuasion, and Religion

#### Starting Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (_a_) a martial weapon and a shield or (_b_) two martial weapons
- (_a_) five javelins or (_b_) any simple melee weapon
- (_a_) a priest's pack or (_b_) an explorer's pack
- Chain mail and a holy symbol

#### Table: Paladin Progression

| LEVEL |  PB | FEATURES                                   | SPELLS KNOWN | 1ST | 2ND | 3RD | 4TH | 5TH |
| ----: | --: | ------------------------------------------ | -----------: | --: | --: | --: | --: | --: |
|   1st |  +2 | Divine Sense, Lay on Hands                 |            - |   - |   - |   - |   - |   - |
|   2nd |  +2 | Divine Smite, Martial Action, Spellcasting |            2 |   2 |   - |   - |   - |   - |
|   3rd |  +2 | Paladin Subclass                           |            3 |   3 |   - |   - |   - |   - |
|   4th |  +2 | Improvement                                |            3 |   3 |   - |   - |   - |   - |
|   5th |  +3 | Multiattack (2/Attack Action)              |            4 |   4 |   2 |   - |   - |   - |
|   6th |  +3 | Aura of Protection                         |            4 |   4 |   2 |   - |   - |   - |
|   7th |  +3 | Subclass Feature                           |            5 |   4 |   3 |   - |   - |   - |
|   8th |  +3 | Improvement                                |            5 |   4 |   3 |   - |   - |   - |
|   9th |  +4 | Aura of Courage                            |            6 |   4 |   3 |   2 |   - |   - |
|  10th |  +4 | Heroic Boon                                |            6 |   4 |   3 |   2 |   - |   - |
|  11th |  +4 | Subclass Feature                           |            7 |   4 |   3 |   3 |   - |   - |
|  12th |  +4 | Improvement                                |            7 |   4 |   3 |   3 |   - |   - |
|  13th |  +5 | Channel Divinity (2/Rest)                  |            8 |   4 |   3 |   3 |   1 |   - |
|  14th |  +5 | Cleansing Touch                            |            8 |   4 |   3 |   3 |   1 |   - |
|  15th |  +5 | Subclass Feature                           |            9 |   4 |   3 |   3 |   2 |   - |
|  16th |  +5 | Improvement                                |            9 |   4 |   3 |   3 |   2 |   - |
|  17th |  +6 | Aura Improvements                          |           10 |   4 |   3 |   3 |   3 |   1 |
|  18th |  +6 | Channel Divinity (3/Rest)                  |           10 |   4 |   3 |   3 |   3 |   1 |
|  19th |  +6 | Improvement                                |           11 |   4 |   3 |   3 |   3 |   2 |
|  20th |  +6 | Epic Boon                                  |           11 |   4 |   3 |   3 |   3 |   2 |

#### Divine Sense

_1st-Level Paladin Feature_

During your turn, you can open your awareness to detect the presence of supernatural forces (no action required). For 1 minute, you know the location of any Celestial, Fiend, or Undead within 60 feet of you that isn't behind total cover. You know the creature type of any being whose presence you sense, but you don't know which specific creature it is. Within the same radius, you also detect the presence of any place or object that has been consecrated or desecrated with the hallow spell. 

You can use this feature a number of times equal to your PB + 1. When you finish a long rest, you regain all uses.

#### Lay On Hands

_1st-Level Paladin Feature_

Your blessed touch can heal wounds. You have a pool of healing power that replenishes when you take a long rest. With that pool, you can restore a total number of hit points equal to 5 × your paladin level. 

As an action, you can touch a willing creature and draw from the pool to restore a number of hit points to that creature up to the maximum amount remaining in your pool. Alternatively, you can expend 5 hit points from your pool of healing to cure the target of one disease or neutralize one poison affecting it. You can cure multiple diseases and neutralize multiple poisons with a single use of this feature, expending hit points separately for each one. 

As a bonus action, you can use this feature to affect yourself instead of a different creature. This feature has no effect on Constructs or Undead.

#### Divine Smite

_2nd-Level Paladin Feature_

Once per turn, when you hit a creature with a weapon attack, you can expend one spell slot to deal extra radiant damage to the target, in addition to the weapon's normal damage. The extra damage is 2d8 for a 1st-circle spell slot, plus 1d8 for each circle higher than 1st, to a maximum of 5d8. The damage increases by 1d8 if the target is a Fiend or Undead.

#### Martial Action

_2nd-Level Paladin Feature_

Your tactical expertise allows you to act quickly on the battlefield. You can take a bonus action on each of your turns in combat to perform a weapon option or one of the martial actions granted by this feature.

Choose one of the following martial actions that you know.

##### Guard

_Requires Wielding a Shield_

As a bonus action, you raise your shield to intercept incoming attacks. Select one enemy creature within 5 feet of you. That creature has disadvantage on the first attack roll it makes against you or an ally within 5 feet of you before the start of your next turn.

##### Wind Up

_Requires Wielding a Heavy or a Versatile Weapon with Both Hands_

As a bonus action, you ready a powerful attack against a nearby target. Select one target you can see within 10 feet of you. If you hit that target with a melee weapon attack before the end of your turn, the first such attack deals extra damage equal to your PB (of the same damage type as the weapon).

#### Spellcasting

_2nd-Level Paladin Feature_

At 2nd level, you enhance your martial prowess with the ability to cast Divine spells.

##### Casting Spells

You know a small number of spells and can cast any of them by using a Divine spell slot of the spell's circle or higher. You don't need to prepare spells ahead of time.

The Paladin Progression table shows how many spells you know and how many Divine spell slots you have at a given level. For example, at 5th level, you have four 1st-circle slots and two 2nd-circle slots. If you know the 1st-circle spell bless and have a 1st-circle and a 2nd-circle spell slot available, you can cast bless using either slot. If you use a 1st-circle slot, you have three 1st-circle slots remaining.

You regain all used spell slots when you finish a long rest.

##### Spells Known of 1st Circle and Higher

At 2nd level, choose two 1st-circle spells from the Divine spell list to learn.

The Spells Known column of the Paladin Progression table shows when you learn additional Divine spells. Each spell you choose must be from a circle for which you have Divine spell slots. For instance, when you reach 5th level as a paladin, you can learn one new Divine spell from the 1st or 2nd circle.

In addition, when you gain a level of paladin, you can choose one Divine spell you know and replace it with another spell of your choice from the Divine spell list. The replacement spell must be of a circle for which you have Divine spell slots.

##### Spellcasting Ability

Charisma (CHA) is your spellcasting ability. Your CHA modifier determines the save DC or the attack modifier for certain spells you cast:

- **Spell save DC** = 8 + your proficiency bonus (PB) + your CHA modifier
- **Spell attack modifier** = your proficiency bonus (PB) + your CHA modifier 

##### Spellcasting Focus 

You can use a holy symbol as a spellcasting focus for your Divine spells.

#### Paladin Subclass

_3rd, 7th, 11th, and 15th-Level Paladin Feature_

Choose a subclass that reflects the oath you swear to uphold, either Devotion or Justice (detailed at the end of this class). Your choice grants you spells and other features at 3rd, 7th, 11th, and 15th level.

##### Oath Spells

Each paladin subclass has a list of oath spells that you can access as soon as you can cast spells of that circle (as shown in the Paladin Progression table). Once you gain such a spell, it is always on your list of known spells, and it doesn't count against the number of spells you know. However, casting an oath spell still expends a Divine spell slot as normal.

If one of these spells isn't on the Divine spell list, it still counts as a Divine spell for you. You can't replace oath spells when you gain a level of paladin.

##### Channel Divinity

Each paladin subclass gives you one or more ways to channel divine energy into magical effects, and each subclass explains how they work.

When you use your Channel Divinity feature, choose which effect you want. Some of these effects require a save, and in those cases, the DC is equal to your spell save DC.

Beginning at 13th level, you can use your Channel Divinity feature twice between rests, then three times at 18th level. When you finish a short or long rest, you regain any expended uses.

#### Improvement

_4th, 8th, 12th, 16th, and 19th-Level Paladin Feature_

Choose one of the following improvements (ability scores can't be raised above 20 with this feature):

- Increase a single ability score by 2.
- Increase two different ability scores by 1 each.
- Increase one ability score by 1 and select a talent from the martial talents list.

#### Multiattack

_5th-Level Paladin Feature_

Your physical prowess has grown. On your turn, you can make two attacks when you take the Attack action.

#### Aura Of Protection

_6th-Level Paladin Feature_

When you or a friendly creature within 10 feet of you makes a save, the creature gains a bonus to the save equal to your CHA modifier (minimum bonus of +1). You must be conscious to grant this bonus. A creature can only receive the benefits of one Aura of Protection feature at a time (that is, auras from multiple paladins don't stack).

#### Aura Of Courage

_9th-Level Paladin Feature_

You and friendly creatures within 10 feet of you can't be frightened while you are conscious.

#### Heroic Boon

_10th-Level Paladin Feature_

Your commitment to the paladin's path grants you a powerful new ability. Choose one of the following heroic boons:

- **Divine Recovery.** When you heal a creature with your Lay on Hands feature, the target can expend one of their hit dice, roll the die, and add their CON modifier to it. The target regains that many hit points, in addition to any healing received from Lay on Hands.
- **Radiant Strikes.** Your every strike is divinely empowered. When you hit a creature with a weapon, the attack deals an extra 1d8 radiant damage. Fiends and Undead instead take 2d8 radiant damage. This extra damage stacks with any damage from your Divine Smite feature.

#### Cleansing Touch

_14th-Level Paladin Feature_

You can use your action to end one spell on yourself or on one willing creature you touch.

You can use this feature a number of times equal to your CHA modifier (minimum of one). You regain expended uses when you finish a long rest.

#### Aura Improvements

_17th-Level Paladin Feature_

The range of your Aura of Protection and Aura of Courage features (and any auras granted by your paladin subclass) increases to 30 feet.

#### Epic Boon

_20th-Level Paladin Feature_

Your commitment to the paladin's path grants you a powerful new ability. You gain the following epic boon:

- **Aura of Salvation.** As an action, you can exude a calming reassurance for 1 hour. While the aura is active, you and friendly creatures within 30 feet of you have resistance to nonmagical damage and automatically succeed on death saving throws. A creature with at least 1 HP that starts its turn in the aura regains hit points equal to your CHA modifier. This effect ends early if you are incapacitated or die. Once used, you can't use it again until you finish a long rest.

### Devotion Subclass

Swearing an oath of Devotion binds a paladin to the principles of duty, honor, justice, and order. These paladins define themselves as holy warriors or knights, pledged to further a righteous cause to which they devote themselves. They typically hold angels, resplendent servants of good, in high regard, often adorning their armor, shield, or weapon with their iconography.

#### Tenets Of Devotion

Though the exact words and strictures of the oath of Devotion vary, its paladins share these tenets.

**_Compassion._** Protect the weak, aid the helpless, and show mercy to your enemies whenever you are able.

**_Courage._** Though caution is wise, never fear to act.

**_Duty._** Do always as you have sworn to do. Obey those who have authority over you.

**_Honesty._** Never tell a lie when the truth will suffice. Your word is your sacred promise.

**_Honor._** Treat others with fairness. Let your deeds prove your character.

#### Devotion Progression

| LEVEL | FEATURES                                                                                   |
| ----: | ------------------------------------------------------------------------------------------ |
|   3rd | Channel Divinity: Sacred Weapon, Channel Divinity: Sanctifying Light, Devotion Oath Spells |
|   7th | Aura of Devotion                                                                           |
|  11th | Purity of Spirit                                                                           |
|  15th | Holy Nimbus                                                                                |

#### Channel Divinity

_3rd-Level Devotion Feature_

You gain the following two Channel Divinity options.

##### Channel Divinity: Sacred Weapon

As an action, you can imbue one weapon you are holding with positive energy. For 1 minute, you add your CHA modifier to attack rolls you make with that weapon (minimum bonus of +1). The weapon also emits bright light in a 20-foot radius and dim light 20 feet beyond that. If the effected weapon isn't already magical, it becomes magical for the duration. You can end this effect on your turn (no action required). It ends early if you fall unconscious.

##### Channel Divinity: Sanctifying Light

As an action, you present your holy symbol and speak a prayer to bathe yourself in a flash of holy light. Each Aberration, Fey, Fiend, and Undead of your choice within 30 feet of you that can see you must make a CHA save. If the creature fails its save, it is blinded for 1 minute. At the end of each of its turns, a target can make a CON save, ending the effect for itself on a success.

#### Devotion Oath Spells

_3rd-Level Devotion Feature_

You gain oath spells at the paladin levels listed in the Devotion Oath Spells table. See the Paladin Subclass class feature for how these spells work.

##### Table: Devotion Oath Spells

| PALADIN | LEVEL SPELLS             |
| ------: | ------------------------ |
|     3rd | _sanctuary_              |
|     5th | _warding bond_           |
|     9th | _protection from energy_ |
|    13th | _stoneskin_              |
|    17th | _mass cure wounds_       |

#### Aura Of Devotion

_7th-Level Devotion Feature_

You and friendly creatures within 10 feet of you can't be charmed while you are conscious. This aura is enhanced by the 17th-level Aura Improvements class feature.

#### Purity Of Spirit

_11th-Level Devotion Feature_

Your connection to divinity gives you constant protection from the influence of supernatural creatures. You always have the following protections against Aberrations, Celestials, Elementals, Fey, Fiends, Undead, and creatures with the Outsider tag:

- Listed creatures have disadvantage on attack rolls against you.
- You can use your Divine Sense feature to detect any listed creatures, not just Celestials, Fiends, and Undead.
- You can't be charmed, frightened, or possessed by listed creatures.

#### Holy Nimbus

_15th-Level Devotion Feature_

As an action, you can emanate a nimbus of sunlight. For 1 minute, bright light shines from you in a 30-foot radius, and dim light shines 30 feet beyond that. This light counts as true sunlight, such as when interacting with Sunlight Hypersensitivity, and it banishes areas of magical darkness created by the darkness spell or similar magic.

When an enemy creature starts its turn in the bright light, it takes radiant damage equal to your paladin level. In addition, for the duration, you have advantage on saves.

Once you use this feature, you can't use it again until you finish a long rest.

## Ranger

### Class Features

As a ranger, you have the following class features.

#### Hit Points

**Hit Dice:** 1d10 per ranger level
**Hit Points at 1st Level:** 10 + your CON modifier
**Hit Points at Higher Levels:** 1d10 (or 6) + your CON modifier per ranger level after 1st

#### Proficiencies

**Armor:** Light armor, medium armor, and shields
**Weapons:** Simple weapons, martial weapons
**Tools:** Your choice of herbalist tools, navigator tools, or trapper tools
**Saves:** STR, DEX
**Skills:** Choose three from Animal Handling, Athletics, Insight, Investigation, Nature, Perception, Stealth, and Survival

#### Starting Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (_a_) scale mail or (_b_) leather armor
- (_a_) two shortswords or (_b_) two simple weapons
- (_a_) a dungeoneer's pack or (_b_) an explorer's pack
- A longbow and quiver of 20 arrows

#### Table: Ranger Progression

| LEVEL |  PB | FEATURES                         | SPELLS KNOWN | 1ST | 2ND | 3RD | 4TH | 5TH |
| ----: | --: | -------------------------------- | -----------: | --: | --: | --: | --: | --: |
|   1st |  +2 | Explorer, Mystic Mark            |            - |   - |   - |   - |   - |   - |
|   2nd |  +2 | Martial Action, Spellcasting     |            2 |   2 |   - |   - |   - |   - |
|   3rd |  +2 | _Ranger Subclass_                |            3 |   3 |   - |   - |   - |   - |
|   4th |  +2 | Improvement                      |            3 |   3 |   - |   - |   - |   - |
|   5th |  +3 | Multiattack (2/Attack Action)    |            4 |   4 |   2 |   - |   - |   - |
|   6th |  +3 | Empowered Mark, Mystic Mark (d6) |            4 |   4 |   2 |   - |   - |   - |
|   7th |  +3 | _Subclass Feature_               |            5 |   4 |   3 |   - |   - |   - |
|   8th |  +3 | Improvement                      |            5 |   4 |   3 |   - |   - |   - |
|   9th |  +4 | Stalker's Step                   |            6 |   4 |   3 |   2 |   - |   - |
|  10th |  +4 | Heroic Boon                      |            6 |   4 |   3 |   2 |   - |   - |
|  11th |  +4 | _Subclass Feature_               |            7 |   4 |   3 |   3 |   - |   - |
|  12th |  +4 | Improvement                      |            7 |   4 |   3 |   3 |   - |   - |
|  13th |  +5 | Mystic Mark (d8)                 |            8 |   4 |   3 |   3 |   1 |   - |
|  14th |  +5 | Keensense                        |            8 |   4 |   3 |   3 |   1 |   - |
|  15th |  +5 | _Subclass Feature_               |            9 |   4 |   3 |   3 |   2 |   - |
|  16th |  +5 | Improvement                      |            9 |   4 |   3 |   3 |   2 |   - |
|  17th |  +6 | Mystic Mark (d10)                |           10 |   4 |   3 |   3 |   3 |   1 |
|  18th |  +6 | Strider                          |           10 |   4 |   3 |   3 |   3 |   1 |
|  19th |  +6 | Improvement                      |           11 |   4 |   3 |   3 |   3 |   2 |
|  20th |  +6 | Epic Boon                        |           11 |   4 |   3 |   3 |   3 |   2 |

#### Explorer

_1st-Level Ranger Feature_

Your ability to deal with environmental challenges is unmatched. You gain the following benefits:

- You gain either a climbing speed or swimming speed equal to your base movement speed.
- You have advantage on checks to track a creature.
- Your speed isn't halved when you move through nonmagical or magical difficult terrain. You #suffer other penalties caused by moving through difficult terrain as normal. ## Mystic Mark

_1st, 6th, 13th, and 17th-Level Ranger Feature_

When you hit a creature with an attack roll, you can mystically mark it as your favored quarry. The creature remains marked for 1 minute, until you use this feature to mark a different creature, or until you become incapacitated.

#### Martial Action

_2nd-Level Ranger Feature_

Your tactical expertise allows you to act quickly on the battlefield. You can take a bonus action on each of your turns in combat to perform a weapon option or one of the martial actions granted by this feature. Choose one of the following martial actions that you know.

##### Aim

_Requires Wielding a Ranged or Thrown Weapon_

As a bonus action, you take the time to increase the effectiveness of your next ranged weapon attack. Select one target you can see. If you make a ranged weapon attack against that target before the end of your turn, double your PB for the first attack roll.

##### Quick Strike

_Requires Wielding Two Light Weapons_

After you take the Attack action on your turn and attack with a Light melee weapon that you're holding in one hand, you can use a bonus action to make two attacks with a different Light melee weapon that you're holding in the other hand| - instead of the one attack typically| granted by two-weapon fighting. Don't add your ability modifier to the damage of these additional attacks unless the modifier is negative.

#### Spellcasting

_2nd-Level Ranger Feature_

At 2nd level, you enhance your martial prowess with the ability to cast Primordial spells.

##### Casting Spells

You know a small number of spells and can cast any of them by using a Primordial spell slot of the spell's circle or higher. You don't need to prepare spells ahead of time.

The Ranger Progression table shows how many spells you know and how many Primordial spell slots you have at a given level. For example, at 5th level, you have four 1st-circle slots and two 2nd-circle slots. If you know the 1st-circle spell animal friendship and have a 1st-circle and a 2nd-circle spell slot available, you can cast animal friendship using either slot. If you use a 1st-circle slot, you have three 1st-circle slots remaining.

You regain all used spell slots when you finish a long rest.

##### Spells Known of 1st Circle and Higher

At 2nd level, choose two 1st-circle spells from the Primordial spell list that you know.

The Spells Known column of the Ranger Progression table shows when you learn additional Primordial spells. Each spell you choose must be from a circle for which you have Primordial spell slots. For instance, when you reach 5th level as a ranger, you can learn one new Primordial spell from the 1st or 2nd circle.

In addition, when you gain a level of ranger, you can choose one Primordial spell you know and replace it with another spell of your choice from the Primordial spell list. The replacement spell must be of a circle for which you have Primordial spell slots.

##### Spellcasting Ability

Wisdom (WIS) is your spellcasting ability. Your WIS modifier determines the save DC or the attack modifier for certain spells you cast:

- **Spell save DC** = 8 + your proficiency bonus (PB) + your WIS modifier
  #- **Spell attack modifier** = your proficiency bonus (PB) + your WIS modifier ### Spellcasting Focus

You can use a druidic focus as a spellcasting focus for your Primordial spells.

#### Ranger Subclass

_3rd, 7th, 11th, and 15th-Level Ranger Feature_

Choose a subclass that reflects your connection to the natural world, either Hunter or Pack Master (detailed at the end of this class). Your choice grants you spells and other features at 3rd, 7th, 11th, and 15th level.

##### Calling Spells

Each ranger subclass has a list of calling spells that you can access as soon as you can cast spells of that circle (as shown in the Ranger Progression table). Once you gain such a spell, it is always on your list of known spells, and it doesn't count against the number of spells you know. However, casting a calling spell still expends a Primordial spell slot as normal. If one of these spells isn't on the Primordial spell list, it still counts as a Primordial spell for you. You can't replace calling spells when you gain a level of ranger.

#### Improvement

_4th, 8th, 12th, 16th, and 19th-Level Ranger Feature_

Choose one of the following improvements (ability scores can't be raised above 20 with this feature):

- Increase a single ability score by 2.
- Increase two different ability scores by 1 each.
- Increase one ability score by 1 and select a talent from either the martial or the technical talents list. While a creature is marked (including for the attack that triggered the mark), you deal an extra 1d4 damage to it (of the same damage type as the weapon) each time you successfully hit it with a weapon attack. You can use this feature a number of times equal to your PB. You regain all uses when you finish a long rest. This extra damage increases as you #gain ranger levels, becoming 1d6 at 6th level, 1d8 at 13th, and 1d10 at 17th. ## Multiattack

_5th-Level Ranger Feature_

Your physical prowess has grown. On your turn, you can make two attacks when you take the Attack action.

#### Empowered Mark

_6th-Level Ranger Feature_

Your instincts have sharpened, granting you supernatural awareness of your quarry. While a creature marked by your Mystic Mark feature is within 60 feet of you, you know its exact location, and it can't gain advantage on attacks against you as a result of being invisible or otherwise unseen. In addition, when you attack a marked creature within 60 feet of you, an inability to see it doesn't impose disadvantage on your attack rolls against it.

#### Stalker's Step

_9th-Level Ranger Feature_

While you are in dim light, darkness, or are lightly obscured or heavily obscured by foliage, mist, or some other natural phenomenon, you can use a bonus action to magically become invisible, along with any equipment you are wearing or carrying, until the start of your next turn. This invisibility ends early if you attack or cast a spell. You can use this feature a number of times equal to your PB and regain all uses when you complete a long rest.

#### Heroic Boon

_10th-Level Ranger Feature_

Your commitment to the ranger's path grants you a powerful new ability. Choose one of the following heroic boons:

- Path of the Predator. When you roll initiative, you can expend a use of Mystic Mark to automatically mark one creature you can see, no attack required. In addition, if a marked creature is reduced to 0 HP, you can use your reaction to transfer the mark to a different creature you can see within 60 feet of the original target.
- Path of the Sage. You learn two cantrips of your choice from the Primordial spell list. You also learn two ritual spells of your choice from the Primordial spell list. Both ritual spells must be from circles you have spell slots for, as shown on the Ranger Progression table. Ritual spells learned this way don't count against your total number of spells known. WIS is your spellcasting ability for cantrips and ritual spells learned in this way. When you gain a level of ranger, you can replace one of these cantrips and one of these rituals with another cantrip or ritual spell from the Primordial spell list, as long as the replacement ritual spell is #still of a circle you have spell slots for. 

#### Keensense

_14th-Level Ranger Feature_

You have keensense to a range of 10 feet. Your keensense ceases to function while you are deafened or otherwise deprived of hearing.

#### Strider

_18th-Level Ranger Feature_

Your movement never provokes opportunity attacks, and you have advantage on any check made to resist an effect that would cause you to become grappled, restrained, or paralyzed or that would otherwise reduce your movement speed to 0 feet.

#### Epic Boon

_20th-Level Ranger Feature_

Your commitment to the ranger's path grants you a powerful new ability. You gain the following epic boon:

- Foe Slayer. You can add your WIS modifier to either the attack roll or the damage roll of #each attack you make against a creature marked by your Mystic Mark on your turn. 

### Hunter Subclass

Rangers who heed the calling of the Hunter are no mere trappers or furriers. They are the last line of defense between the natural and the supernatural world. Hunters seek, stalk, and slay monstrous predators like outsiders, fiends, and undead who devastate populations with their malign magic.

#### Table: Hunter Progression

| LEVEL | FEATURES                                                   |
| ----: | ---------------------------------------------------------- |
|   3rd | Hunter Calling Spells, Killer Instinct, Relentless Pursuit |
|   7th | Favored Foe                                                |
|  11th | No Escape                                                  |
|  15th | Predator's Shield                                          |

#### Hunter Calling Spells

_3rd-Level Hunter Feature_

You gain calling spells at the ranger levels listed in the Hunter Calling Spells table. See the Ranger Subclass class feature for how these spells work.

##### Table: Hunter Calling Spells

| RANGER LEVEL | SPELLS                        |
| -----------: | ----------------------------- |
|          3rd | protection from evil and good |
|          5th | misty step                    |
|          9th | nondetection                  |
|         13th | banishment                    |
|         17th | greater hold                  |

#### Killer Instinct

_3rd-Level Hunter Feature_

As a bonus action, choose a creature within 60 feet of you that you can see. You immediately learn the creature's immunities, resistances, and vulnerabilities, or you learn if it has none. This feature doesn't function if the target is magically concealed by a nondetection spell or similar effect that counters divination magic. You can use this feature a number of times equal to your PB and regain all uses of it when you finish a long rest.

#### Relentless Pursuit

_3rd-Level Hunter Feature_

Your tenacity wears down even potent foes. When you hit a creature with a weapon attack, you deal extra damage if the target is below its hit point maximum. The extra damage is equal to the amount your Mystic Mark feature deals at your level and is of the same damage type as the weapon. You can deal this extra damage only once per turn.

#### Favored Foe

_7th-Level Hunter Feature_

As part of a long rest, you can spend time reviewing your research and preparing to face a specific type of monster. Choose a type of enemy: Aberration, Beast, Celestial, Construct, Dragon, Elemental, Fey, Fiend, Giant, Monstrosity, Ooze, Plant, or Undead. For 24 hours, creatures of that type have disadvantage on attack rolls against you. You also have advantage on saves against being charmed, frightened, or possessed by them. At the end of your next long rest, you can choose the same type of creature or a different creature type as your Favored Foe.

#### No Escape

_11th-Level Hunter Feature_

When a creature marked by your mystic mark attempts to move, you can use your reaction to magically teleport up to 30 feet. If you teleport to a space within your weapon's reach of the target, you can immediately make an opportunity attack as part of the same reaction.

#### Predator's Shield

_15th-Level Hunter Feature_

When you take damage from a creature you can see, you can use your reaction to supernaturally ward yourself against that creature for a short time. You have resistance to all damage dealt by the target for 1 minute, including resistance to the damage dealt by the triggering attack. This effect ends early if you become incapacitated. Once used, this feature can't be used again until you finish a long rest.

## Rogue

### Class Features

As a rogue, you have the following class features.

#### Hit Points

- **Hit Dice:** 1d8 per rogue level
- **Hit Points at 1st Level:** 8 + your CON modifier
- **Hit Points at Higher Levels:** 1d8 (or 5) + your CON modifier per rogue level after 1st

#### Proficiencies

- **Armor:** Light armor
- **Weapons:** Simple weapons, martial weapons with the Finesse property
- **Tools:** Thieves' tools
- **Saves:** DEX, INT
- **Skills:** Choose four from Acrobatics, Athletics, Deception, Insight, Intimidation, Investigation, Perception, Performance, Persuasion, Sleight of Hand, and Stealth

#### Starting Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (_a_) a rapier or (_b_) a shortsword
- (_a_) a shortbow and quiver of 20 arrows or (_b_) a shortsword
- (_a_) a burglar's pack, (_b_) a dungeoneer's pack, or (_c_) an explorer's pack
- Leather armor, two daggers, and a set of thieves' tools

#### Table: Rogue Progression

| LEVEL |  PB | SNEAK ATTACK | FEATURES                                   |
| ----: | --: | -----------: | ------------------------------------------ |
|   1st |  +2 |          1d6 | Expertise (2), Sneak Attack, Thieves’ Cant |
|   2nd |  +2 |          1d6 | Cunning Action                             |
|   3rd |  +2 |          2d6 | Rogue Subclass                             |
|   4th |  +2 |          2d6 | Improvement                                |
|   5th |  +3 |          3d6 | Uncanny Dodge                              |
|   6th |  +3 |          3d6 | Evasion, Expertise (4)                     |
|   7th |  +3 |          4d6 | Subclass Feature                           |
|   8th |  +3 |          4d6 | Improvement                                |
|   9th |  +4 |          5d6 | Reliable Talent                            |
|  10th |  +4 |          5d6 | Heroic Boon                                |
|  11th |  +4 |          6d6 | Subclass Feature                           |
|  12th |  +4 |          6d6 | Improvement                                |
|  13th |  +5 |          7d6 | Precise Critical (1 Die)                   |
|  14th |  +5 |          7d6 | Keensense                                  |
|  15th |  +5 |          8d6 | Subclass Feature                           |
|  16th |  +5 |          8d6 | Improvement                                |
|  17th |  +6 |          9d6 | Precise Critical (2 Dice)                  |
|  18th |  +6 |          9d6 | Elusive                                    |
|  19th |  +6 |         10d6 | Improvement                                |
|  20th |  +6 |         10d6 | Epic Boon                                  |

#### Expertise

_1st and 6th-Level Rogue Feature_

Choose two of your skill proficiencies, or one skill proficiency and one tool proficiency. Double your PB for any ability check you make that uses either of the chosen proficiencies. At 6th level, choose two more of your proficiencies (any combination of skills or tools) to gain this benefit.

#### Sneak Attack

_1st-Level Rogue Feature_

You know how to strike subtly and exploit a foe's distraction. Once per turn, you can deal an extra 1d6 damage to one creature you hit with an attack if you have advantage on the attack roll. The weapon you use must have the Finesse property or be a ranged weapon. You don't need advantage on the attack roll if another enemy of the target is within 5 feet of it, that enemy isn't incapacitated, and you don't have disadvantage on the attack roll. The amount of your extra damage you deal increases as you gain levels in this class, as shown in the Sneak Attack column of the Rogue Progression table.

#### Thieves' Cant

_1st-Level Rogue Feature_

During your rogue training, you learned Thieves' Cant, a secret mix of dialect, jargon, and code that allows you to hide messages in seemingly normal conversation. Only another creature who knows Thieves' Cant understands such messages. It takes four times longer to convey a message in Thieves' Cant than it does to speak the same idea plainly. In addition, you understand a set of secret signs and symbols used to convey short, simple messages, such as whether an area is dangerous or the territory of a thieves' guild, whether loot is nearby, or whether people in an area are easy marks or will provide a safe house for thieves on the run.

#### Cunning Action

_2nd-Level Rogue Feature_

Your quick thinking and agility allow you to move and act quickly. You can use a bonus action to take the Dash, Disengage, or Hide action.

#### Rogue Subclass

_3rd, 7th, 11th, and 15th-Level Rogue Feature_

Choose a subclass that represents your specialized set of skills, either Enforcer or Thief (detailed at the end of this class). Your choice grants you features at 3rd, 7th, 11th, and 15th level.

#### Improvement

_4th, 8th, 12th, 16th, and 19th-Level Rogue Feature_

Choose one of the following improvements (ability scores can't be raised above 20 with this feature):

- Increase a single ability score by 2.
- Increase two different ability scores by 1 each.
- Increase one ability score by 1 and select a talent from the technical talents list.

#### Uncanny Dodge

_5th-Level Rogue Feature_

When an attacker that you can see hits you with an attack, you can use your reaction to reduce the attack's damage against you by half.

#### Evasion

_6th-Level Rogue Feature_

You can dodge out of the way of certain area effects, such as a blue dragon's lightning breath or a fireball spell. When you are subjected to an effect that allows you to make a DEX save to take only half damage, you instead take no damage if you succeed on the save and only half damage if you fail.

#### Reliable Talent

_9th-Level Rogue Feature_

You have refined your chosen skills until they approach perfection. When you make an ability check with a skill, tool, or vehicle that you have proficiency with, treat a d20 roll of 9 or lower as if you rolled a 10.

#### Heroic Boon

_10th-Level Rogue Feature_

Your commitment to the rogue's path grants you a powerful new ability. Choose one of the following heroic boons:

- **Escape Artist.** When you are subjected to an effect that allows you to make any kind of save (including DEX saves) to take only half damage, you instead take no damage if you succeed on the save and only half damage if you fail.
- **Jack of All Trades.** When you gain a new talent, you can choose it from any talent list. Immediately gain one talent of your choice (that you meet the prerequisites for) when you gain this feature.

#### Precise Critical

_13th and 17th-Level Rogue Feature_

You score a critical hit on a d20 roll of 19 or 20 with ranged weapons and weapons with the Finesse property. In addition, you can roll one additional weapon damage die (not an additional Sneak Attack die) when determining the extra damage for a critical hit with a ranged weapon attack or attack made with a Finesse weapon.
This extra damage increases to two additional dice at 17th level.

#### Keensense

_14th-Level Rogue Feature_

You have keensense to a range of 10 feet. Your keensense ceases to function while you are deafened or otherwise deprived of hearing.

#### Elusive

_18th-Level Rogue Feature_

You are so evasive that attackers rarely gain the upper hand against you. While you aren't incapacitated, attack rolls can't have advantage against you, regardless of the source of advantage.

#### Epic Boon

_20th-Level Rogue Feature_

Your commitment to the rogue's path grants you a powerful new ability. You gain the following epic boon:

- **Stroke of Luck.** You have got it when it counts. If your attack misses a target within normal range, you can turn the miss into a hit. Alternatively, if you fail an ability check, you can treat the d20 roll as a 20. Once you use this feature, you can't use it again until you finish a short or long rest.

### Thief Subclass

You have a reputation for quick thinking and quicker fingers. Leave throat - cutting and con - running to lesser scoundrels. You live to liberate treasures held under lock and key. The thrill of bypassing a sealed door, complex trap, or other "impassable" obstacle is the true prize - followed by the payday that comes from whatever you took.


#### Table: Thief Progression

| LEVEL | FEATURES                      |
| ----: |-------------------------------|
|   3rd | Fast Hands, Second-Story Work |
|   7th | Appraising Eye                |
|  11th | Trap Specialist               |
|  15th | Thief's Reflexes              |

#### Fast Hands

_3rd-Level Thief Feature_

Experience has honed your skills, allowing you to accomplish precision work in a flash. In addition to its standard uses, you can now use the bonus action granted by your Cunning Action feature to do any of the following:

- Make a DEX (Sleight of Hand) check.
- Take the Use an Object action.
- Use thieves' tools to attempt to disarm a trap or open a lock.

#### Second-Story Work

_3rd-Level Thief Feature_

You've never met a wall you couldn't conquer, and climbing them is second nature. You gain a climbing speed equal to your walking speed. If you already have a climbing speed when you gain this feature, it increases by 10 feet. In addition, when you make a long jump, you cover a number of feet equal to your walking speed if you move at least 10 feet on foot immediately before the jump. When you make a standing long jump, you can leap half your walking speed. Either way, each foot you clear on the jump costs a foot of movement. In the event a STR (Athletics) check is required to clear or extend a jump, you can choose to make a DEX (Acrobatics) check instead.

#### Appraising Eye

_7th-Level Thief Feature_

You've developed an eye for quality. As an action, you can inspect any object within 10 feet of you that you can see to learn whether it is nonmagical or magical. If the object is nonmagical, you immediately learn its approximate value in gold pieces. You also learn whether the object is fake or could conceal other objects inside it (though you don't learn whether it is currently concealing objects or what those objects are).

If the object is magical, you can spend 1 minute examining it to learn its type, rarity, whether it is cursed, and if it requires attunement (and any specific attunement requirements it has). After you have examined a magic item in this way, you learn how to use it and can ignore any class or feature requirements that would normally prevent you from using it (though you still must abide by any level restrictions). If a magic item requires the use of a spellcasting ability, use your DEX to determine your spell save DC or spell attack bonus.

#### Trap Specialist

_11th-Level Thief Feature_

When you or a creature within 5 feet of you triggers a trap, you can use your reaction to roll an ability check to attempt to disarm the trap. If you are successful, the trap is disarmed and not triggered. If you are unsuccessful, the trap is triggered as normal.

In addition, you can now disarm any magical traps that would typically require the use of the dispel magic spell. When you do so, make an ability check using only your DEX modifier, without adding any other modifiers to the roll. If the result meets or exceeds the trap's DC (your GM has this number), it is disarmed as if you had successfully cast the dispel magic spell.

#### Thief's Reflexes

_15th-Level Thief Feature_

You have become adept at laying ambushes and quickly escaping danger. Now, you can take two turns during the first round of any combat. You take your first turn at your normal initiative and your second turn at your initiative minus 10. You can't use this feature if you are surprised.

## Sorcerer

### Class Features

As a sorcerer, you have the following class features.

#### Hit Points

- **Hit Dice:** 1d6 per sorcerer level
- **Hit Points at 1st Level:** 6 + your CON modifier
- **Hit Points at Higher Levels:** 1d6 (or 4) + your CON modifier per sorcerer level after 1st

#### Proficiencies

- **Armor:** None
- **Weapons:** Simple weapons
- **Tools:** None
- **Saves:** CON, CHA
- **Skills:** Choose two from Arcana, Deception, Insight, Intimidation, Persuasion, and Religion

#### Starting Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (_a_) a light crossbow and 20 bolts or (_b_) any simple weapon
- (_a_) a component pouch or (_b_) an arcane focus
- (_a_) a dungeoneer's pack or (_b_) an explorer's pack
- Two daggers

#### Table: Sorcerer Progression

| LEVEL |  PB | SORCERY POINTS | FEATURES                                  | CANTRIPS KNOWN | SPELLS KNOWN | 1ST | 2ND | 3RD | 4TH | 5TH | 6TH | 7TH | 8TH | 9TH |
| ----: | --: | -------------: | ----------------------------------------- | -------------: | -----------: | --: | --: | --: | --: | --: | --: | --: | --: | --: |
|   1st |  +2 |              2 | Font of Magic, Spellcasting               |              3 |            2 |   2 |   - |   - |   - |   - |   - |   - |   - |   - |
|   2nd |  +2 |              3 | Metamagic (2)                             |              3 |            3 |   3 |   - |   - |   - |   - |   - |   - |   - |   - |
|   3rd |  +2 |              4 | Sorcerer Subclass                         |              3 |            4 |   4 |   2 |   - |   - |   - |   - |   - |   - |   - |
|   4th |  +2 |              5 | Improvement                               |              4 |            5 |   4 |   3 |   - |   - |   - |   - |   - |   - |   - |
|   5th |  +3 |              6 | Sorcerous Renewal (1 Die)                 |              4 |            6 |   4 |   3 |   2 |   - |   - |   - |   - |   - |   - |
|   6th |  +3 |              7 | Metamagic (3)                             |              4 |            7 |   4 |   3 |   3 |   - |   - |   - |   - |   - |   - |
|   7th |  +3 |              8 | Subclass Feature                          |              4 |            8 |   4 |   3 |   3 |   1 |   - |   - |   - |   - |   - |
|   8th |  +3 |              9 | Improvement                               |              4 |            9 |   4 |   3 |   3 |   2 |   - |   - |   - |   - |   - |
|   9th |  +4 |             10 | Sorcerous Renewal (2 Dice)                |              4 |           10 |   4 |   3 |   3 |   3 |   1 |   - |   - |   - |   - |
|  10th |  +4 |             11 | Heroic Boon                               |              5 |           11 |   4 |   3 |   3 |   3 |   2 |   - |   - |   - |   - |
|  11th |  +4 |             12 | Subclass Feature                          |              5 |           12 |   4 |   3 |   3 |   3 |   2 |   1 |   - |   - |   - |
|  12th |  +4 |             13 | Improvement                               |              5 |           12 |   4 |   3 |   3 |   3 |   2 |   1 |   - |   - |   - |
|  13th |  +5 |             14 | Metamagic (4), Sorcerous Renewal (3 Dice) |              5 |           13 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   - |
|  14th |  +5 |             15 | Devour Spell                              |              5 |           13 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   - |   - |
|  15th |  +5 |             16 | Subclass Feature                          |              5 |           14 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   - |
|  16th |  +5 |             17 | Improvement                               |              5 |           14 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   - |
|  17th |  +6 |             18 | Sorcerous Renewal (4 Dice)                |              5 |           15 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   1 |
|  18th |  +6 |             19 | Metamagic (5)                             |              5 |           15 |   4 |   3 |   3 |   3 |   3 |   1 |   1 |   1 |   1 |
|  19th |  +6 |             20 | Improvement                               |              5 |           15 |   4 |   3 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |
|  20th |  +6 |             21 | Epic Boon                                 |              5 |           15 |   4 |   3 |   3 |   3 |   3 |   2 |   2 |   1 |   1 |

#### Font Of Magic

_1st-Level Sorcerer Feature_

You begin to draw from an internal wellspring of magic. This wellspring is represented by sorcery points, which allow you to create a variety of magical effects.

##### Sorcery Points

You start with 2 sorcery points at 1st level, and you gain more as you reach higher levels, as shown in the Sorcery Points column of the **Sorcerer Progression** table. You can never have more sorcery points than shown in the table for your level. You regain all spent sorcery points when you finish a long rest.

##### Flexible Casting

You can sacrifice spell slots to gain additional sorcery points or use your sorcery points to gain additional spell slots. You learn other ways to use your sorcery points as you reach higher levels.

**Converting a Spell Slot to Sorcery Points.** As a bonus action, you can expend one Arcane spell slot and gain a number of sorcery points equal to the spell slot's circle.

**Creating Spell Slots.** You can spend sorcery points to gain one Arcane spell slot as a bonus action on your turn. The **Creating Spell Slots** table shows the cost of creating a spell slot of a given circle. You can create spell slots no higher than 5th circle with this feature, and the spell slots you create vanish when you finish a long rest.

###### Table: Creating Spell Slots

| SPELL SLOT CIRCLE | SORCERY POINT COST |
| ----------------: | -----------------: |
|               1st |                  2 |
|               2nd |                  3 |
|               3rd |                  5 |
|               4th |                  6 |
|               5th |                  7 |

#### Spellcasting

_1st-Level Sorcerer Feature_

As a conduit for arcane power, you can cast Arcane spells.

##### Cantrips

At 1st level, choose three cantrips from the Arcane spell list to learn. You choose more Arcane cantrips to learn at higher levels, as shown in the Cantrips Known column of the Sorcerer Progression table.

##### Casting Spells

You know a small number of spells and can cast any of them by using an Arcane spell slot of the spell's circle or higher. You don't need to prepare spells ahead of time.

The **Sorcerer Progression** table shows how many spells you know and how many Arcane spell slots you have at a given level. For example, at 3rd level, you have four 1st-circle slots and two 2nd-circle slots. If you know the 1st-circle spell _magic missle_ and have a 1st-circle and a 2nd-circle spell slot available, you can cast _magic missle_ using either slot. If you use a 1st-circle slot, you have three 1st-circle slots remaining.

You regain all used spell slots when you finish a long rest.

##### Spells Known of 1st Circle and Higher

At 1st level, choose two 1st-circle spells from the Arcane spell list to learn.

The Spells Known column of the Sorcerer Progression table shows when you learn additional Arcane spells. Each spell you choose must be from a circle for which you have Arcane spell slots. For instance, when you reach 3rd level as a sorcerer, you can learn one new Arcane spell of 1st or 2nd circle.

In addition, when you gain a level of sorcerer, you can choose one Arcane spell you know and replace it with another spell of your choice from the Arcane spell list. The replacement spell must be of a circle for which you have Arcane spell slots.

##### Spellcasting Ability

Charisma (CHA) is your spellcasting ability. Your CHA modifier determines the save DC or the attack modifier for certain spells you cast:

- **Spell save DC** = 8 + your proficiency bonus (PB) + your CHA modifier
- **Spell attack modifier** = your proficiency bonus (PB) + your CHA modifier

##### Spellcasting Focus

You can use an arcane focus as a spellcasting focus for your Arcane spells.

#### Metamagic

_2nd, 6th, 13th, and 18th-Level Sorcerer Feature_

You gain the ability to twist your spells to suit your needs in the moment. You start with two of the following Metamagic feature options of your choice. You gain another option at 6th, 13th, and 18th levels.

You can use only one Metamagic option on a spell when you cast it, unless otherwise noted. To alter a spell with metamagic, a spell must count as an Arcane spell for you.

When your sorcerer level grants you the Improvement feature, you can replace one Metamagic option you know with a different Metamagic option from this list.

##### Careful Spell

When you cast a spell that forces creatures to make a save, you can spend 1 sorcery point to exclude some of them from the effect. When you do, choose a number of those creatures up to half your sorcerer level (rounded up). A chosen creature automatically succeeds on its save and takes no damage from the spell.

You can use the Careful Spell option even if you have already used a different Metamagic option during the casting of the spell.

##### Distant Spell

When you cast a spell that has a range of 5 feet or greater, you can spend 1 sorcery point to increase its range by 100 feet. Spells with a range of touch instead have their range increased to 30 feet.

##### Empowered Spell

When you roll damage for a spell, you can spend 1 sorcery point to reroll a number of damage dice up to your CHA modifier (minimum of one). You must use the new roll results.

You can use the Empowered Spell option even if you have already used a different Metamagic option during the casting of the spell.

##### Enlarged Spell

When you cast a spell with a range of self that affects an area (not a specific target), you can spend 3 sorcery points to increase the size of the spell's area of effect in one of the following ways (depending on the shape of the spell effect):

- **Circle, Cylinder, or Sphere.** The radius of circle, sphere, or circular base of the cylinder increases by 5 feet. For example, the antimagic field spell could be altered to affect a 15-foot-radius sphere (instead of a 10-foot-radius sphere).
- **Cone.** The cone's size increases by 15 feet. For example, the burning hands spell could be altered to affect a 30 - foot cone (instead of a 15 - foot cone).
- **Cube.** The length of each cube face increases by 5 feet. For example, the thunderwave spell could be altered to affect a 20 - foot cube (instead of a 15 - foot cube).
- **Line.** The length of the line increases by 15 feet. For example, the lightning bolt spell could be altered to affect a 115 - foot line (instead of a 100 - foot line).

##### Extended Spell

When you cast a spell that has a duration of 1 minute or longer, you can spend 1 sorcery point to increase its duration to 10 minutes. Spells with a duration of 10 minutes or longer instead have their duration doubled, to a maximum duration of 24 hours.

##### Flexible Spell

When you cast a spell, you can spend 1 sorcery point to change the spell's damage type to any other damage type, except psychic. Spells that naturally deal psychic damage can't benefit from the Flexible Spell option.

##### Heightened Spell

When you cast a spell that forces a target to make a save to resist its effects, you can spend 3 sorcery points to give one target of the spell disadvantage on its first save made against the spell.

##### Hunting Spell

When you cast a spell that requires a target to make a save or take damage, you can spend 2 sorcery points to cause the spell to deal half damage even if a target succeeds on its save. This damage still affects targets who could normally avoid taking all damage on a successful save (via Evasion or similar features).

##### Lucky Spell

When you cast a spell that requires an attack roll and miss, you can spend 2 sorcery points to add the total number of Luck that you currently have to the attack roll, potentially turning a failure into a success. Luck isn't expended by this Metamagic option and can subsequently be spent on the attack roll normally.

##### Quickened Spell

When you cast a spell that has a casting time of 1 action, you can spend 2 sorcery points to change the casting time to 1 bonus action for this casting. You can't use this feature to cast two 1st-circle or higher spells on the same turn.

##### Retain Spell

When you cast a spell that requires concentration, you can spend 2 sorcery point to have advantage on any concentration checks made to maintain the spell for its duration. Your concentration isn't automatically broken for that spell if you become incapacitated, meaning that you can still attempt concentration checks as you normally would.

You can use the Retain Spell option even if you have already used a different Metamagic option during the casting of the spell.

##### Shielding Spell

When you cast a spell, you can spend 2 sorcery points to gain a number of temporary hit points equal to 3 × the spell's circle. These temporary hit points last for 1 hour.

##### Subtle Spell

When you cast a spell, you can spend 1 sorcery point to cast it without any somatic or verbal components.

##### Twinned Spell

When you cast a spell that targets only one creature and doesn't have a range of self, you can spend a number of sorcery points equal to 1 + the spell's circle to target a second creature in range with the same spell. (Cantrips cost only 1 sorcery point.)

To be eligible, a spell must be incapable of targeting more than one creature at the spell's current circle. For example, _magic missle_ and scorching ray aren't eligible but _acid arrow_ and _ray of enfeeblement_ are.

#### Sorcerer Subclass

_3rd, 7th, 11th, and 15th-Level Sorcerer Feature_

Choose a subclass that reflects the origins of your magical power, either Chaos or Draconic (detailed at the end of this class). Your choice grants you spells and other features at 3rd, 7th, 11th, and 15th level.

#### Origin Spells

Each sorcerer subclass has a list of origin spells that you can access as soon as you can cast spells of that circle (as shown in the Sorcerer Progression table). Once you gain such a spell, it is always on your list of known spells and doesn't count against the number of spells you know. However, casting an origin spell still expends an Arcane spell slot as normal.

If one of these spells isn't on the Arcane spell list, it still counts as an Arcane spell for you. You can't replace origin spells when you gain a level of sorcerer.

#### Improvement

_4th, 8th, 12th, 16th, and 19th-Level Sorcerer Feature_

Choose one of the following improvements (ability scores can't be raised above 20 with this feature):

- Increase a single ability score by 2.
- Increase two different ability scores by 1 each.
- Increase one ability score by 1 and select a talent from the magic talents list.

#### Sorcerous Renewal

_5th, 9th, 13th, and 17th-Level Sorcerer Feature_

When you finish a short rest, roll 1d4 + 1 and regain that many sorcery points.

At higher levels, your Sorcerous Renewal feature improves: you roll 2d4 + 1 at 9th level, 3d4 + 1 at 13th, and 4d4 + 1 at 17th.

#### Heroic Boon

_10th-Level Sorcerer Feature_

Your commitment to the sorcerer's path grants you a powerful new ability. Choose one of the following heroic boons:

- **Arcane Instruction.** You find new ways to tap into internal magical resources. When you fail an ability check, you can spend 1 sorcery point to add your CHA modifier to the result, potentially turning a failure into a success.
- **Innate Spell.** You learn one spell of 1st or 2nd circle from the Arcane, Primordial, or Wyrd spell list. You can cast that spell at its lowest circle by expending a number of sorcery points equal to that spell's circle instead of using a spell slot. When you gain a level in sorcerer, you can replace your innate spell with another spell of 1st or 2nd circle from the available lists.

#### Devour Spell

_14th-Level Sorcerer Feature_

When a creature you can see targets you with a spell, you can use your reaction to attempt to immediately draw the spell's power into yourself. Make a CHA check with a DC equal to 10 + the spell's circle. On a success, you and every other target of the spell have advantage on saves against it and take only half as much damage from it. You also gain a number of sorcery points equal to the spell's circle.

Alternatively, you can target a magical effect within 30 feet of you that was created by a spell, such as fog cloud or wall of fire. On a successful CHA check, the spell ends.

Once you successfully devour a spell, you can't use this feature again until you finish a long rest, unless you spend 4 sorcery points to do so.

#### Epic Boon

_20th-Level Sorcerer Feature_

Your commitment to the sorcerer's path grants you a powerful new ability. You gain the following epic boon:

- **Arcane Conjunction.** When a spell or magical effect affects you, you can use your reaction to target one creature you can see within 120 feet of you. That creature is affected as though it were also the target. Once used, you can't use this feature again until you finish a short or long rest, unless you spend 10 sorcery points to do so.

### Draconic Subclass

Through lineage, bargain, or unrequited gift, the origins of your magic lie in the preternatural power of dragons. These beings, monumental in their age, power, and size, possess unshakeable bearing, unstoppable might, and mastery over the elements of the natural world.

#### Table: Draconic Progression

| Sorcerer Level | Features                                                           |
| -------------: | ------------------------------------------------------------------ |
|            3rd | _Draconic Origin Spells_, _Draconic Resilience_, _Dragon Ancestor_ |
|            7th | _Elemental Affinity_                                               |
|           11th | _Imperious Wings_                                                  |
|           15th | _Draconian Vengeance_                                              |

#### Draconic Origin Spells

_3rd-Level Draconic Feature_

You gain origin spells at the sorcerer levels listed in the Dragon Ancestor Damage Type and Spells table. See the Sorcerer Subclass class feature for how these spells work.

Note that one of the spells you gain at each listed sorcerer level is determined by the type of dragon you select as your ancestor (see Dragon Ancestor).

#### Table: Draconic Origin Spells

| SORCERER LEVEL | SPELLS                                    |
| -------------: | ----------------------------------------- |
|            3rd | _command_, dragon ancestor spell          |
|            5th | _elemental blade_, dragon ancestor spell  |
|            7th | _fear_, dragon ancestor spell             |
|            9th | _elemental shield_, dragon ancestor spell |
|           11th | _dominate_, dragon ancestor spell         |

#### Draconic Resilience

_3rd-Level Draconic Feature_

As magic flows through your body, it causes physical traits of your dragon ancestors to emerge. Your hit point maximum increases immediately by 1 and by an additional 1 when you gain a level of sorcerer.

In addition, parts of your skin are covered by a thin sheen of dragon - like scales. When you aren't wearing armor, your AC equals 13 + your DEX modifier.

#### Dragon Ancestor

_3rd-Level Draconic Feature_

You begin to manifest traits of the type of dragon that instilled you with power. Choose that dragon's type now. This choice also dictates some of your spells gained with your Draconic Origin Spells feature, and the damage type associated with each dragon is used by additional features you gain later.

You can now speak, read, and write Draconic. In addition, when you make an ability check when interacting with or recalling information about dragons, treat any d20 roll less than your sorcerer level as if you rolled a number equal to your sorcerer level.

#### Table: Dragon Ancestor Damage Type And Spells

| Dragon Type         | Damage Type | 3rd Level       | 5th Level      | 7th Level        | 9th Level              | 11th Level                |
| ------------------- | ----------- | --------------- | -------------- | ---------------- | ---------------------- | ------------------------- |
| Black or Copper     | Acid        | _grease_        | _acid arrow_   | _stinking cloud_ | _stone shape_          | _cloudkill_               |
| Blue or Bronze      | Lightning   | _thunderwave_   | _invisibility_ | _lightning bolt_ | _greater invisibility_ | _conjure elemental_ (air) |
| Brass, Gold, or Red | Fire        | _burning hands_ | _heat metal_   | _fireball_       | _wall of fire_         | _flame strike_            |
| Green               | Poison      | _entangle_      | _barkskin_     | _stinking cloud_ | _blight_               | _contagion_               |
| Silver or White     | Cold        | _fog cloud_     | _hold_         | _sleet storm_    | _ice storm_            | _cone of cold_            |

#### Elemental Affinity

_7th-Level Draconic Feature_

When you cast a spell that deals damage of the type associated with your draconic ancestry (including spells with a damage type modified by features such as your Flexible Spell metamagic option), you can spend 1 sorcery point to gain one of the following benefits:

- Each target takes additional damage equal to your PB.
- You gain resistance to that damage type for 1 minute.

#### Imperious Wings

_11th-Level Draconic Feature_

You gain the ability to sprout a pair of dragon wings from your back, gaining a fly speed equal to your walking speed. You can create these wings as a bonus action on your turn, and they last until you dismiss them (also as a bonus action on your turn). While the wings are manifested, creatures that can see you have disadvantage on checks and saves to avoid being frightened or intimidated by you.

You can't manifest your wings while wearing armor.

#### Draconian Vengeance

_15th-Level Draconic Feature_

As an action, you can target one creature within 60 feet of you that you can see to brand it with your draconic element. The target must succeed on a CHA save against your spell save DC or become vulnerable to the damage type associated with your draconic ancestry until the end of your next turn. A target resistant to that damage type loses that resistance for the duration, but a target immune to the damage type is still immune to it, even if the target fails the save.

Once used, you can't use this feature again until you finish a long rest, unless you spend 4 sorcery points to do so.

## Warlock

### Class Features

As a warlock, you have the following class features.

#### Hit Points

- **Hit Dice:** 1d8 per warlock level
- **Hit Points at 1st Level:** 8 + your CON modifier
- **Hit Points at Higher Levels:** 1d8 (or 5) + your CON modifier per warlock level after 1st

#### Proficiencies

- **Armor:** Light armor, medium armor, shields
- **Weapons:** Simple weapons
- **Tools:** None
- **Saves:** WIS, CHA
- **Skills:** Choose two from Arcana, Deception, History, Intimidation, Investigation, Nature, and Religion

#### Starting Equipment

You start with the following equipment, in addition to the
equipment granted by your background:

- (_a_) a light crossbow and 20 bolts or (_b_) any simple weapon
- (_a_) a component pouch or (_b_) a wyrd focus
- (_a_) a scholar's pack or (_b_) a dungeoneer's pack
- Leather armor, any simple weapon, and two daggers

#### Table: Warlock Progression

| LEVEL |  PB | INVOCATIONS KNOWN | FEATURES                           | CANTRIPS KNOWN | SPELLS KNOWN | 1ST | 2ND | 3RD | 4TH | 5TH |
| ----: | --: | ----------------: | ---------------------------------- | -------------: | -----------: | --: | --: | --: | --: | --: |
|   1st |  +2 |                 - | Eldritch Blast, Pact Boon          |              - |            - |   - |   - |   - |   - |   - |
|   2nd |  +2 |                 2 | Eldritch Invocations, Spellcasting |              2 |            2 |   2 |   - |   - |   - |   - |
|   3rd |  +2 |                 2 | Pact Magic (2/Rest), Warlock Subclass                   |              2 |            3 |   3 |   - |   - |   - |   - |
|   4th |  +2 |                 2 | Improvement                        |              3 |            3 |   3 |   - |   - |   - |   - |
|   5th |  +3 |                 3 | Eldritch Blast (2 Beams)           |              3 |            4 |   4 |   2 |   - |   - |   - |
|   6th |  +3 |                 3 | Enhanced Boon                      |              3 |            4 |   4 |   2 |   - |   - |   - |
|   7th |  +3 |                 4 | Subclass Feature                   |              3 |            5 |   4 |   3 |   - |   - |   - |
|   8th |  +3 |                 4 | Improvement                        |              3 |            5 |   4 |   3 |   - |   - |   - |
|   9th |  +4 |                 5 | Eldritch Blast (3 Beams)           |              3 |            6 |   4 |   3 |   2 |   - |   - |
|  10th |  +4 |                 5 | Heroic Boon                        |              4 |            6 |   4 |   3 |   2 |   - |   - |
|  11th |  +4 |                 6 | Subclass Feature                   |              4 |            7 |   4 |   3 |   3 |   - |   - |
|  12th |  +4 |                 6 | Improvement                        |              4 |            7 |   4 |   3 |   3 |   - |   - |
|  13th |  +5 |                 7 | Pact Magic (3/Rest)                |              4 |            8 |   4 |   3 |   3 |   1 |   - |
|  14th |  +5 |                 7 | Eldritch Blast (4 Beams)           |              4 |            8 |   4 |   3 |   3 |   1 |   - |
|  15th |  +5 |                 8 | Subclass Feature                   |              4 |            9 |   4 |   3 |   3 |   2 |   - |
|  16th |  +5 |                 8 | Improvement                        |              4 |            9 |   4 |   3 |   3 |   2 |   - |
|  17th |  +6 |                 9 | Pact Magic (4/Rest)                |              4 |           10 |   4 |   3 |   3 |   3 |   1 |
|  18th |  +6 |                 9 | Patron’s Favor                     |              4 |           10 |   4 |   3 |   3 |   3 |   1 |
|  19th |  +6 |                10 | Improvement                        |              4 |           11 |   4 |   3 |   3 |   3 |   2 |
|  20th |  +6 |                10 | Epic Boon                          |              4 |           11 |   4 |   3 |   3 |   3 |   2 |

#### Eldritch Blast

_1st, 5th, 9th, and 14th-Level Warlock Feature_

As a result of binding yourself to otherworldly powers, you can conjure a baleful magical energy. As an action, you can send a beam of crackling eldritch power toward a creature within 120 feet of you. When you do so, make a ranged spell attack against the target. On a hit, the target takes 1d10 force damage.

Upon achieving higher levels of warlock, you can create more than one beam: two beams at 5th level, three at 9th, and four at 14th. You can direct the beams at the same or different target. You make a separate attack roll for each beam.

#### Pact Boon

_1st-Level Warlock Feature_

The initial pact that grants you your warlock powers is sealed with the gift of a Pact Boon. You gain one of the following boons of your choice.

##### Pact of the Blade

You can use your action to create a pact weapon in your empty hand. You can choose the form that this melee weapon takes each time you create it. You have proficiency with it while you wield it. This weapon counts as magical for the purpose of overcoming resistance and immunity to nonmagical attacks and damage. When you attack with the weapon, you can use your CHA modifier, instead of STR or DEX, for attack and damage rolls.

Your pact weapon disappears if it is more than 5 feet away from you for 1 minute or more. It also disappears if you use this feature again, if you dismiss the weapon (no action required), or if you die.

You can transform an existing weapon into your pact weapon by performing a special ritual while you hold the weapon. You perform the ritual over the course of 1 hour, which can be done during a short or long rest. You can then dismiss the weapon, shunting it into an extradimensional space, and it appears when you create your pact weapon thereafter. You can't affect an artifact or a sentient weapon in this way. The weapon ceases being your pact weapon if you die, if you perform the 1 - hour ritual on a different weapon, or if you use a 1 - hour ritual to break your bond to it. The weapon appears at your feet if it is in the extradimensional space when the bond breaks.

##### Pact of the Chain

You learn a more potent version of the find familiar ritual and can cast it without the need for any material components. The spell doesn't count against your number of spells known. A familiar summoned with this feature has the following differences from a standard familiar summoned by the spell:

- When you cast the spell, you can choose one of the normal familiar forms or one of the following special  forms: blink dog, imp, pseudodragon, or quasit.
- You can telepathically communicate or see through your familiar's eyes as long as it is on the same plane as you, ignoring the standard 100 - foot range restriction. In addition, while perceiving through your familiar's senses, you can also speak through your familiar in your own voice, even if your familiar is normally incapable of speech.
- Your familiar can attack. In combat, your familiar shares your initiative count, but it takes its turn immediately after yours. It obeys your verbal commands (no action required by you). If you don't issue any commands, it takes the Dodge action and uses its move to avoid danger.

##### Pact of the Tome

You receive an eldritch grimoire called a Book of Shadows. You can use your Book of Shadows as a spellcasting focus for your spells. When you gain this feature, choose three cantrips from any source spell list (they don't have to be from the same list). While the book is on your person, you can cast those cantrips. These cantrips count as Wyrd spells for you.

If your Book of Shadows is lost or destroyed, you can perform a 1 - hour ceremony to create a replacement. The replacement contains any spells previously transcribed within it. This ceremony can be performed as part of a short or long rest, and it destroys the previous grimoire-if it still exists. The book is unreadable by anyone but you, and it is instantly destroyed when you die.

#### Eldritch Invocations

_2nd-Level Warlock Feature_

In your study of occult lore, you have unearthed eldritch invocations. These fragments of forbidden knowledge imbue you with magical abilities that abide beyond any mere spell duration.

You gain two eldritch invocations of your choice, though you must meet any prerequisites. Invocation options are detailed at the end of the class description. At certain warlock levels, you gain additional invocations of your choice, as shown in the Invocations Known column of the **Warlock Progression** table.

In addition, when you gain a level in this class, you can choose one invocation you know and replace it with another invocation that you meet the prerequisites for.

#### Spellcasting

_2nd-Level Warlock Feature_

Your eldritch power deepens, giving you the ability to cast Wyrd spells.

##### Cantrips

At 2nd level, choose two cantrips from the Wyrd spell list to learn. You choose more Wyrd cantrips to learn at higher levels, as shown in the Cantrips Known column of the **Warlock Progression** table.

##### Casting Spells

You know a small number of spells and can cast any of them by using a Wyrd spell slot of the spell's circle or higher. You don't need to prepare spells ahead of time.

The **Warlock Progression** table shows how many spells you know and how many spell slots you have per day at a given level. For example, at 5th level, you have four 1st-circle slots and two 2nd-circle slots. If you know the 1st-circle spell bane and have a 1st-circle and a 2nd-circle spell slot available, you can cast bane using either slot. If you use a 1st-circle slot, you have three 1st-circle slots remaining. You regain all used spell slots when you finish a long rest.

##### Spells Known of 1st-Circle and Higher

At 2nd level, choose two 1st-circle spells from the Wyrd spell list to learn.

The Spells Known column of the Warlock Progression table shows when you learn additional Wyrd spells. Each spell you choose must be from a circle for which you have Wyrd spell slots. For instance, when you reach 5th level as a warlock, you can learn one new Wyrd spell of 1st or 2nd circle.

In addition, when you gain a level of warlock, you can choose one Wyrd spell you know and replace it with another spell of your choice from the Wyrd spell list. The replacement spell must be of a circle for which you have Wyrd spell slots.

##### Spellcasting Ability

Charisma (CHA) is your spellcasting ability. Your CHA modifier determines the save DC or the attack modifier for certain spells you cast:

- **Spell save DC** = 8 + your proficiency bonus (PB) + your CHA modifier
- **Spell attack modifier** = your proficiency bonus (PB) + your CHA modifier

##### Spellcasting Focus

You can use a wyrd focus as a spellcasting focus for your Wyrd spells.

#### Warlock Subclass

_3rd, 7th, 11th, and 15th-Level Warlock Feature_

Choose a subclass that reflects the type of entity that becomes your patron, either Fiend or Reaper (detailed at the end of this class). Your choice grants you spells and other features at 3rd, 7th, 11th, and 15th level.

##### Pact Spells

Each warlock subclass has a list of pact spells that you can access as soon as you can cast spells of that circle (as shown in the **Warlock Progression** table). Once you gain such a spell, it is always on your list of known spells and doesn't count against the number of spells you know. However, casting a pact spell still expends a Wyrd spell slot as normal.

If one of these spells isn't on the Wyrd spell list, it still counts as a Wyrd spell for you. You can't replace pact spells when you gain a level of warlock.

##### Pact Magic

Your patron gives you access to a special reservoir of power called Pact Magic. You can expend one use of Pact Magic to cast any Pact Spell you know without expending a spell slot, though they are always treated as cast at the highest-circle warlock spell slot you can access (see **Warlock Progression**).

You can use this feature twice, whether casting the same or different spells from your Pact Spells. You gain additional uses of Pact Magic at higher warlock levels: at 13th level, you can use it three times between rests, and at 17th level, you can use it four times between rests. You regain all expended uses of Pact Magic when you finish a short or long rest.

#### Improvement

_4th, 8th, 12th, 16th, and 19th-Level Warlock Feature_

Choose one of the following improvements (ability scores can't be raised above 20 with this feature):

- Increase a single ability score by 2.
- Increase two different ability scores by 1 each.
- Increase one ability score by 1 and select a talent from the magic talents list.

#### Enhanced Boon

_6th-Level Warlock Feature_

Your patron enhances your Pact Boon as a reward for your service. You gain one of the following enhancements as determined by your chosen Pact Boon. If you have more than one Pact Boon, choose which one is enhanced.

**Pact of the Blade.** You can attack with your pact weapon twice, instead of once, when you take the Attack action on your turn.

**Pact of the Chain.** When you complete a short or long rest, your familiar gains temporary hit points equal to your PB + your CHA modifier. In addition, when you make an attack against a creature within 5 feet of your familiar, your familiar can use its reaction to give you advantage on the attack roll.

**Pact of the Tome.** You can now inscribe rituals into your Book of Shadows. Choose two rituals of 1st or 2nd circle (in any combination) from the Wyrd ritual list. The rituals appear in the book and don't count against the number of spells you know. With your Book of Shadows in hand, you can cast the chosen rituals.

On your adventures, you can add other Wyrd rituals you find to your Book of Shadows if a ritual's circle is equal to or less than half your warlock level (rounded up) and if you can spare the time to transcribe the spell. For each circle of the ritual, the transcription process takes 2 hours and costs 50 gp for the rare inks needed to inscribe it.

#### Heroic Boon

_10th-Level Warlock Feature_

Your commitment to the warlock's path grants you a powerful new ability. Choose one of the following heroic boons:

- **Echoes of Knowledge.** You learn one 1st-circle and one 2nd-circle spell of your choice from any spell list, they count as Wyrd spells for you. The chosen spells can't be rituals, and they don't count against your total spells known. These spells are added to your list of Pact Spells and can be cast by expending a use of Pact Magic or by expending Wyrd spell slots as normal.
- **Echoes of Power.** When you successfully hit with one of your Eldritch Blast beams and roll a 10 on the damage die, you can roll the d10 again and add the result as extra force damage dealt by that beam.

#### Patron's Favor

_18th-Level Warlock Feature_

You can call upon your patron's power by expending a use of your Pact Magic feature to cast any spell you know of 5th-circle or lower from any spell list.

#### Epic Boon

_20th-Level Warlock Feature_

Your commitment to the warlock's path grants you a powerful new ability. You gain the following epic boon:

- **Eldritch Master.** If you start your turn with no uses of Pact Magic remaining, you can beseech your patron to immediately restore all expended uses (no action required). You must finish a long rest before you can use this feature again.

### Eldritch Invocations

This section lists the eldritch invocations available for warlocks to learn. If an invocation has prerequisites, you must meet them to learn it. You can learn the invocation at the same time that you meet its prerequisites.

If a prerequisite lists a level requirement, that is the minimum warlock level required (you can take it at higher warlock levels).

#### Agonizing Blast

_Prerequisite: None_

When you use your Eldritch Blast feature, add your CHA modifier to the damage each beam deals on a successful hit.

#### Armor Of Shadows

_Prerequisite: None_

While you aren't wearing armor or wielding a shield, your AC becomes 13 + your CHA modifier. This effect is suppressed while you are unconscious or in an area affected by an antimagic field spell.

#### Ascendant Step

_Prerequisite: 9th Level_

You can cast the levitate spell on yourself as often as you wish, without expending a spell slot or material components.

#### Bewitching Whispers

_Prerequisite: 7th Level_

You can cast the compulsion spell once without expending a spell slot or material components. You can't do so again until you finish a long rest.

#### Beyond Sight

_Prerequisite: None_

You can see in dim light, darkness, and magical darkness as though it were bright light, to a range of 120 feet.

#### Boon Savant

_Prerequisite: 7th-Level Warlock, Second Boon_

Your second Pact Boon becomes more powerful, gaining the benefits detailed in your Enhanced Boon feature.

#### Chains Of Carceri

_Prerequisite: 15th Level_

You can cast the greater hold spell without expending a spell slot or material components. You can't do so again until you finish a long rest.

#### Dreadful Word

_Prerequisite: 7th Level_

You can cast the confusion spell once without expending a spell slot or material components. You can't do so again until you finish a long rest.

#### Eldritch Burst

_Prerequisite: None_

You gain the following benefits when you use yourEldritch Blast feature:

- You don't have disadvantage on ranged spell attack rolls to hit a prone target if it is more than 5 feet away from you.
- You don't have disadvantage on ranged spell attack rolls if you are within 5 feet of a hostile creature who can see you and who isn't incapacitated.

#### Eldritch Sight

_Prerequisite: None_

You can cast the _detect magic_ spell as often as you wish, without expending a spell slot.

#### Eldritch Spear

_Prerequisite: None_

When you use your Eldritch Blast feature, you can now target creatures within 300 feet of you.

#### Fiendish Vigor

_Prerequisite: None_

You can cast the false life spell on yourself as often as you wish, without expending a spell slot or material components. You can cast it at the highest circle you have a Wyrd spell slot for (see **Warlock Progression** table).

#### Gaze Of Two Minds

_Prerequisite: None_

You can use your action to touch a willing Humanoid and perceive through its senses until the end of your next turn. As long as the creature is on the same plane as you, you can use your action on subsequent turns to maintain this connection, extending the duration until the end of your next turn. While perceiving through the other creature's senses, you benefit from any special senses possessed by that creature, and you are blinded and deafened to your own surroundings.

#### Lifedrinker

_Prerequisite: 11th Level_

When you hit a creature with a weapon attack, the creature takes additional necrotic damage equal to your CHA modifier (minimum of 1).

#### Mask Of Many Faces

_Prerequisite: None_

You can cast the disguise self spell as often as you wish, without expending a spell slot.

#### Mire The Mind

_Prerequisite: 5th Level_

You can cast the slow spell without expending a spell slot or material components. You can't do so again until you finish a long rest.

#### Misty Visions

_Prerequisite: None_

You can cast the silent image spell as often as you wish, without expending a spell slot or material components.

#### Mystic Arcanum

_Prerequisite: 11th Level_

Your patron bestows a magical secret called an arcanum. Choose one non - ritual spell from the Wyrd spell list as this arcanum. The highest circle spell you can choose is determined by your current warlock level, as shown in the **Maximum Circle by Level** table.
You can cast your arcanum spell once without expending a spell slot. You must finish a long rest before you can cast it in this way again. Alternatively, if your arcanum is of a circle for which you have spell slots, you can expend a spell slot to cast it as you would a standard spell.
You can take this invocation multiple times, choosing a different spell each time.

##### Table: Maximum Circle By Level

| WARLOCK LEVEL | MAXIMUM SPELL CIRCLE OF ARCANUM |
| ------------: | ------------------------------- |
|          11th | 6th Circle                      |
|          13th | 7th Circle                      |
|          15th | 8th Circle                      |
|          17th | 9th Circle                      |

#### One With Shadows

_Prerequisite: 5th Level_

When you are in an area of dim light, darkness, or magical darkness, you can use your action to become invisible until you move or take an action or a reaction.

#### Otherworldly Leap

_Prerequisite: 9th Level_

You can cast the longstrider spell on yourself as often as you wish, without expending a spell slot or material components.

#### Patron's Anchor

_Prerequisite: None_

When you make a CON save to maintain concentration on a Wyrd spell or a spell cast with an Eldritch Invocation, you can choose to make a CHA save instead. In addition, you have advantage on the first concentration save you make each round.

#### Repelling Blast

_Prerequisite: None_

When you successfully hit a creature with one or more beams created by your Eldritch Blast feature, you can push the creature up to 10 feet per beam away from you in a straight line (in addition to dealing damage). If this movement is interrupted by the target encountering a solid surface (such as being pushed into a stone wall), the target also takes 1d6 bludgeoning damage for each 10-foot increment it moved.

#### Sculptor Of Flesh

_Prerequisite: 7th Level_

You can cast the polymorph spell without expending a spell slot or material components. You can't do so again until you finish a long rest.

#### Second Boon

_Prerequisite: 5th Level_

You gain the benefits of a second boon from the options described in the 1st level feature Pact Boon: Pact of the Blade, Pact of the Chain, or Pact of the Tome.

#### Sign Of Ill Omen

_Prerequisite: 5th Level_

You can cast the bestow curse spell without expending a spell slot or material components. You can't do so again until you finish a long rest.

#### Spirit Translator

_Prerequisite: None_

You can cast the comprehend languages spell on yourself as often as you wish, without expending a spell slot or material components.

#### Stolen Knowledge

_Prerequisite: None_

You gain proficiency in any two skills or tools of your choice (in any combination).

You can take this invocation multiple times, choosing different proficiencies each time.

#### Thief Of Five Fates

_Prerequisite: None_

You can cast bane as a 1st-circle spell as often as you wish, without expending a spell slot or material components.

#### Visions Of Distant Realms

_Prerequisite: 15th Level_

You can cast the arcane eye spell as often as you wish, without expending a spell slot or material components.

#### Whispers Of The Grave

_Prerequisite: 9th Level_

You can perform the speak with dead ritual as often as you wish, without a ritual book or material components.

#### Witch Sight

_Prerequisite: 15th-Level_

You can see the true form of any creature with the Shapechanger tag or creature concealed by illusion or transmutation magic while the creature is within 30 feet of you and within line of sight.

### Fiend Subclass

Your patron is a greater fiend who holds dominion over lesser demons or devils. Fiendish patrons are uncontestably bound to the forces of evil - though the warlocks they choose rarely are. These patrons often delight in granting power to mortals, even if those mortals openly strive against their destructive aims. Whether these tendencies are exercises in corruption or serve a more nefarious design, few can say.

#### Table: Fiend Progression

| WARLOCK LEVEL | FEATURES                               |
| ------------: | -------------------------------------- |
|           3rd | Dark One's Blessing, Fiend Pact Spells |
|           7th | Dark One's Own Luck                    |
|          11th | Fiendish Resilience                    |
|          15th | Hurl Through Hell                      |

#### Dark One's Blessing

_3rd-Level Fiend Feature_

When you reduce a hostile creature to 0 HP or when a hostile creature within 30 feet of you is reduced to 0 HP, you gain temporary hit points equal to your PB + your warlock level. These hit points last until expended or until you complete a long rest.

#### Fiend Pact Spells

_3rd-Level Fiend Feature_

You gain pact spells at the warlock levels listed in the **Fiend Pact Spells** table. See the Warlock Subclass class feature for how these spells work.

##### Table: Fiend Pact Spells

| WARLOCK LEVEL | SPELLS                        |
| ------------: | ----------------------------- |
|           3rd | _burning hands_, _command_    |
|           5th | _scorching ray_, _suggestion_ |
|           9th | _fireball_, _stinking cloud_  |
|          13th | _blight_, _wall of fire_      |
|          17th | _dominate_, _flame strike_    |

#### Dark One's Own Luck

_7th-Level Fiend Feature_

You can call on your patron to alter fate in your favor. When you make an ability check or a save, you can use this feature to add 1d10 to your roll.

Once you use this feature, you can't use it again until you finish a short or long rest.

#### Fiendish Resilience

_11th-Level Fiend Feature_

You can choose one damage type when you finish a short or long rest. You gain resistance to that damage type until you choose a different one with this feature.

#### Hurl Through Hell

_15th-Level Fiend Feature_

When you hit a creature with an attack, you can use this feature to instantly transport the target, causing it to disappear and hurtle through a nightmare landscape.

At the end of your next turn, the target returns to the space it previously occupied or to the nearest unoccupied space.

If the target is not a Fiend, it takes 10d10 psychic damage as it reels from its horrific experience.

Once you use this feature, you can't use it again until you finish a long rest.

## Wizard

### Class Features

As a wizard, you have the following class features.

#### Hit Points

- **Hit Dice:** 1d6 per wizard level
- **Hit Points at 1st Level:** 6 + your CON modifier
- **Hit Points at Higher Levels:** 1d6 (or 4) + your CON modifier per wizard level after 1st

#### Proficiencies

- **Armor:** None
- **Weapons:** Simple weapons
- **Tools:** None
- **Saves:** INT, WIS
- **Skills:** Choose two from Arcana, History, Insight, Investigation, Medicine, and Religion

#### Starting Equipment

You start with the following equipment, in addition to the equipment granted by your background:

- (_a_) a quarterstaff or (_b_) a dagger
- (_a_) a component pouch or (_b_) an arcane focus
- (_a_) a scholar's pack or (_b_) an explorer's pack
- A spellbook

#### Table: Wizard Progression

| LEVEL |  PB | FEATURES                      | CANTRIPS KNOWN | RITUALS KNOWN | 1ST | 2ND | 3RD | 4TH | 5TH | 6TH | 7TH | 8TH | 9TH |
| ----: | --: | ----------------------------- | -------------: | ------------: | --: | --: | --: | --: | --: | --: | --: | --: | --: | ---- | --- | ------------- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
|   1st |  +2 | Arcane Recovery, Spellcasting |              3 |             1 |   2 |   - |   - |   - |   - |   - |   - |   - |   - |
|   2nd |  +2 | Magic Sense                   |              3 |             1 |   3 |   - |   - |   - |   - |   - |   - |   - |   - |
|   3rd |  +2 | Wizard Subclass               |              3 |             2 |   4 |   2 |   - |   - |   - |   - |   - |   - |   - |
|   4th |  +2 | Improvement                   |              4 |             2 |   4 |   3 |   - |   - |   - |   - |   - |   - |   - |
|   5th |  +3 | Rote Spell (1st-Circle)       |              4 |             3 |   4 |   3 |   2 |   - |   - |   - |   - |   - |   - |
|   6th |  +3 | Superior Recovery             |              4 |             3 |   4 |   3 |   3 |   - |   - |   - |   - |   - |   - |
|   7th |  +3 | Subclass Feature              |              4 |             4 |   4 |   3 |   3 |   1 |   - |   - |   - |   - |   - |
|   8th |  +3 | Improvement                   |              4 |             4 |   4 |   3 |   3 |   2 |   - |   - |   - |   - |   - |
|   9th |  +4 | Rote Spell (2nd-Circle)       |              4 |             5 |   4 |   3 |   3 |   3 |   1 |   - |   - |   - |   - |
|  10th |  +4 | Heroic Boon                   |              5 |             5 |   4 |   3 |   3 |   3 |   2 |   - |   - |   - |   - |
|  11th |  +4 | Subclass Feature              |              5 |             6 |   4 |   3 |   3 |   3 |   2 |   1 |   - |   - |   - |
|  12th |  +4 | Improvement                   |              5 |             6 |   4 |   3 |   3 |   3 |   2 |   1 |   - |   - |   - |
|  13th |  +5 | Rote Spell (3rd-Circle)       |              5 |             7 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   - |   - |
|  14th |  +5 | Spellguard                    |              5 |             7 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   - |   - |
|  15th |  +5 | Subclass Feature              |              5 |             8 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   - |
|  16th |  +5 | Improvement                   |              5 |             8 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   - |
|  17th |  +6 | Rote Spell (4th-Circle)       |              5 |             9 |   4 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |   1 | 18th | +6  | Spell Mastery |     |     | 9   | 4   | 3   | 3   | 3   | 3   | 1   | 1   | 1   | 1   |
|  19th |  +6 | Improvement                   |              5 |             9 |   4 |   3 |   3 |   3 |   3 |   2 |   1 |   1 |   1 |
|  20th |  +6 | Epic Boon                     |              5 |             9 |   4 |   3 |   3 |   3 |   3 |   2 |   2 |   1 |   1 |

#### Arcane Recovery

_1st-Level Wizard Feature_

You have learned to regain some of your magical energy by studying your spellbook. Once per day, when you finish a short rest, you can recover expended Arcane spell slots of your choice. Recovered spell slots can have a combined circle total equal to or less than half your wizard level (rounded up).

For example, if you're a 4th-level wizard, you can recover up to two circles' worth of spell slots. So you could choose to recover either a single 2nd-circle spell slot or two 1st- circle spell slots.

#### Spellcasting

_1st-Level Wizard Feature_

As a student of Arcane magic, you have a spellbook containing spells that show the first glimmerings of your true power.

##### Cantrips

At 1st level, choose three cantrips from the Arcane spell list to learn. You choose more Arcane cantrips to learn at higher levels, as shown in the Cantrips Known column of the Wizard Progression table.

##### Spellbook

At 1st level, your spellbook contains six 1st-circle Arcane spells of your choice. It is the repository of all the Arcane spells you know - except for your cantrips, which are so simple and well - rehearsed that you don't even need to write them down.

###### Your Spellbook

The spells you automatically add to your spellbook as you gain levels reflect the spell research you conduct on your own. However, you might find other spells during your adventures.

**Copying a Spell into the Book.** When you find an Arcane spell of 1st circle or higher, you can add it to your spellbook if it is of a spell circle you can prepare and if you can make time to decipher and copy it. For each circle of the spell, the process takes 2 hours and costs 50 gp.

**Replacing the Book.** You can copy a spell from your own spellbook into another book. This is faster and easier since you understand your own notation and already know how to cast the copied spell. If you lose your spellbook, you can use the same procedure to transcribe the spells you have prepared into a new spellbook. Filling out the remainder of your spellbook requires you to find new spells, as normal.

##### Preparing Spells

You must prepare spells in advance before you can cast them. You can prepare any spell in your spellbook for which you have Arcane spell slots. (You determine which spell slots you can access by checking your level on the Wizard Progression table.) You can choose a number of spells equal to your INT modifier + your wizard level (minimum of one spell). This is your list of prepared spells from which you can cast. Preparing a new list of spells requires time studying your spellbook and re - memorizing incantations and gestures: at least 1 minute per spell circle for each spell you change. You can change your list of prepared spells as part of a long rest.

##### Casting Spells

You have prepared a number of spells and can cast any of them by using an Arcane spell slot of the spell's circle or higher.

The Wizard Progression table shows how many Arcane spell slots you have at a given level. For example, at 3rd level, you have four 1st-circle and two 2nd-circle spell slots, and with a 16 INT, you can have six prepared spells of 1st or 2nd circle, in any combination. You only have two spell slots for 2nd-circle spells though, so if you prepare only 2nd-circle spells, you won't be able to use your 1st-circle spell slots at all.

Casting a spell doesn't remove it from your list of prepared spells, it just uses up a spell slot. You regain all used spell slots when you finish a long rest.

##### Learning Spells of 1st Circle and Higher

Each time you gain a wizard level, you can add two Arcane spells of your choice to your spellbook for free. Each spell must be of a circle for which you have Arcane spell slots, as shown on the Wizard Progression table. During your adventures, you might also find other Arcane spells to add to your spellbook.

##### Spellcasting Ability

Intelligence (INT) is your spellcasting ability. Your INT modifier determines the save DC or the attack modifier for certain spells you cast:

- **Spell save DC** = 8 + your proficiency bonus (PB) + your INT modifier
- **Spell attack modifier** = your proficiency bonus (PB) + your INT modifier

##### Rituals

You can also cast a type of long - form spell called a ritual. Rituals don't need to be prepared, and they don't use up spell slots.

At 1st level, choose one ritual from the Arcane ritual list. You learn more rituals at higher levels, as shown in the Rituals Known column of the Wizard Progression table, but only from a circle for which you have spell slots. Rituals you learn don't count against the number of spells you learn at each level.

Rituals are contained in your spellbook alongside your regular spells, and new rituals written on spell scrolls can be copied into your spellbook like normal Arcane spells.

##### Spellcasting Focus

You can use an arcane focus as a spellcasting focus for your Arcane spells.

#### Magic Sense

_2nd-Level Wizard Feature_

You learn to perceive magical workings. As an action, you can open your awareness to detect magical forces. Until the end of your next turn, you know the location of creatures with spellcasting ability, ongoing spell effects, or magic items within 30 feet of you. If the magical effect is the result of an ongoing spell, you learn which school of magic the spell belongs to.

This sense can penetrate most barriers, but it is blocked by 1 foot of stone, 1 inch of common metal, a thin sheet of lead, or 3 feet of wood or dirt.

You can use this feature a number of times equal to your PB + 1. When you finish a long rest, you regain all uses.

#### Wizard Subclass

_3rd, 7th, 11th, and 15th-Level Wizard Feature_

Choose a subclass that reflects your specialized field of magical study, either Battle Mage or Cantrip Adept (detailed at the end of this class). Your choice grants you features at 3rd, 7th, 11th, and 15th level.

#### Improvement

_4th, 8th, 12th, 16th, and 19th-Level Wizard Feature_

Choose one of the following improvements (ability scores can't be raised above 20 with this feature):

- Increase a single ability score by 2.
- Increase two different ability scores by 1 each.
- Increase one ability score by 1 and select a talent from the magic talents list.

#### Rote Spell

_5th, 9th, 13th, and 17th-Level Wizard Feature_

Your continued practice of spellcraft has honed your mind, allowing you to affix a limited number of spells- called rote spells - in your mind. Choose one 1st-circle Arcane spell from your spellbook, and that spell is now a rote spell. You always have a rote spell prepared, and it doesn't count against the number of spells you can prepare during a long rest. Casting a rote spell still uses a spell slot as normal.

Over the course of 8 hours or as part of a long rest, you can exchange one rote spell for a different Arcane spell of the same circle contained in your spellbook.

At higher levels, you can select more rote spells: you choose a 2nd-circle Arcane spell to become a rote spell at 9th level, a 3rd-circle Arcane spell at 13th, and a 4th-circle Arcane spell at 17th.

#### Superior Recovery

_6th-Level Wizard Feature_

When you use your Arcane Recovery feature, you can choose to swap out a number of prepared Arcane spells with different Arcane spells from your spellbook - in addition to recovering Arcane spell slots. You can swap out a number of prepared spells equal to half your PB (rounded down) in this way.

#### Heroic Boon

_10th-Level Wizard Feature_

Your commitment to the wizard's path grants you a powerful new ability. Choose one of the following heroic boons:

- Rite of the Ritualist. When you learn a new ritual as part of gaining a level of wizard, you can choose it from any source of magic. In addition, you can now copy ritual spells from any source of magic into your spellbook. Any rituals gained in this way count as Arcane spells for you.
- Rite of the Source Master. Choose the Divine, Primordial, or Wyrd source of magic. When you add new spells to your spellbook as part of gaining a level of wizard (including the level you gain this feature), you can choose spells from the Arcane spell list or spells from your chosen source. Each spell must be a of a circle for which you have spell slots. In addition, you can now copy spells of your chosen source into your spellbook. Any spells gained in this way count as Arcane spells for you.

#### Spellguard

_14th-Level Wizard Feature_

Your knowledge of magic allows you to better assess the intentions and power of hostile spells and spell attacks, increasing your chance to avoid their effects. You have advantage on saves against spells and resistance to damage dealt by spells and spell attacks.

#### Spell Mastery

_18th-Level Wizard Feature_

You can cast each of your rote spells at their lowest circle once without expending a spell slot. Once you cast a rote spell, you can't cast that same spell in this way again until you finish a short or long rest. If you want to cast any of your rote spells at a higher circle, you must expend an Arcane spell slot as normal.

#### Epic Boon

_20th-Level Wizard Feature_

Your commitment to the wizard's path grants you a powerful new ability. You gain the following epic boon:

- **Archmage.** When you cast a spell of 1st circle or higher and that spell expends an Arcane spell slot, you can choose to roll a d10. If the number rolled is higher than the circle of the expended spell slot, you automatically recover that slot. For example, if you expend a 1st- circle spell slot, a result of 2 or higher on the d10 means that you recover that 1st-circle spell slot. Once you successfully recover a spell slot in this way, you can't use this feature again until you complete a short rest.

### Battle Mage Subclass

Wizards who follow the Battle Mage tradition aren't interested in theoretical musings or tedious experiments. Instead, they pursue new ways to enhance their power so that they can destroy their foes (and defend their allies) with ever - greater efficiency.

#### Table: Battle Mage Progression

| Wizard Level | Features                                                |
| -----------: | ------------------------------------------------------- |
|          3rd | _Expanded Talent List_, _Spell Ward_, _Tactical Caster_ |
|          7th | _Contingency Plan_                                      |
|         11th | _Blasting Power_                                        |
|         15th | _Counterstrike_                                         |

#### Expanded Talent List

_3rd-Level Battle Mage Feature_

When your gain a new talent, you can select it from either the magic or the martial talents list.

#### Spell Ward

_3rd-Level Battle Mage Feature_

You can redirect a portion of your spellcasting energy into a defensive shield. When you cast an Arcane spell of 1st circle or higher, you can simultaneously weave a protective ward around yourself. While the ward is active, you gain the following benefits if you aren't wearing medium or heavy armor:

- You gain a bonus to your armor class (AC) equal to your PB.
- You have resistance to bludgeoning, piercing, and slashing damage.

The ward lasts for 1 minute, but ends early if you are knocked unconscious or if your turn ends and you haven't cast an Arcane spell of 1st circle or higher since your last turn. You can also choose to dismiss your ward at any time (no action required by you).

You can use this feature a number of times equal to your PB, and you regain all uses of it when you finish a long rest.

#### Tactical Caster

_3rd-Level Battle Mage Feature_

When you cast an Arcane spell that causes damage, you can choose yourself and any number of allies you can see to be immune to the damage caused by the spell. You can use this feature a number of times equal to your PB, and you regain all uses of it when you finish a long rest.

#### Contingency Plan

_7th-Level Battle Mage Feature_

When you fail to hit a creature with a spell attack, you can use your reaction to redirect the spell toward a different target within the spell’s range. You must make a new spell attack roll for the new target. If you miss the new target, you can’t redirect again with the same spell attack.

#### Blasting Power

_11th-Level Battle Mage Feature_

When you deal damage with an Arcane spell, you can reroll any 1s you roll on any number of the damage dice. You must take the new result for any dice rerolled in this way (even if the new result is also a 1).

#### Counterstrike

_15th-Level Battle Mage Feature_

When a creature succeeds on a save against an Arcane spell you cast and would take no damage or otherwise suffer any effects, they instead take force damage equal to a number of d6 dice equal to the spell’s circle + your INT modifier.
